/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.display;

import java.util.Objects;

public final class DisplayModel {
    private String displayName;
    private String summary;
    private String example;

    public static DisplayModelBuilder builder() {
        return new DisplayModelBuilder();
    }

    private DisplayModel() {
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getExample() {
        return this.example;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DisplayModel) {
            DisplayModel other = (DisplayModel)obj;
            return Objects.equals(other.getDisplayName(), this.getDisplayName()) && Objects.equals(other.getSummary(), this.getSummary()) && Objects.equals(other.getExample(), this.getExample());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.summary, this.example);
    }

    public static final class DisplayModelBuilder {
        private final DisplayModel product = new DisplayModel();

        private DisplayModelBuilder() {
        }

        public DisplayModelBuilder displayName(String displayName) {
            this.product.displayName = displayName;
            return this;
        }

        public DisplayModelBuilder summary(String summary) {
            this.product.summary = summary;
            return this;
        }

        public DisplayModelBuilder example(String example) {
            this.product.example = example;
            return this;
        }

        public DisplayModel build() {
            return this.product;
        }
    }
}

