/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.streaming.object.iterator.Consumer;
import org.mule.runtime.core.internal.streaming.object.iterator.ConsumerStreamingIterator;
import org.mule.runtime.core.internal.streaming.object.iterator.ListConsumer;
import org.mule.runtime.core.policy.PolicyManager;
import org.mule.runtime.core.streaming.CursorProviderFactory;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.streaming.PagingProviderProducer;
import reactor.core.publisher.Mono;

public class PagedOperationMessageProcessor
extends OperationMessageProcessor {
    private final ExtensionConnectionSupplier connectionSupplier;

    public PagedOperationMessageProcessor(ExtensionModel extensionModel, OperationModel operationModel, ConfigurationProvider configurationProvider, String target, ResolverSet resolverSet, CursorProviderFactory cursorProviderFactory, ExtensionManager extensionManager, PolicyManager policyManager, ExtensionConnectionSupplier connectionSupplier) {
        super(extensionModel, operationModel, configurationProvider, target, resolverSet, cursorProviderFactory, extensionManager, policyManager);
        this.connectionSupplier = connectionSupplier;
    }

    @Override
    protected Mono<Event> doProcess(Event event, ExecutionContextAdapter<OperationModel> operationContext) {
        try {
            Event resultEvent = (Event)super.doProcess(event, operationContext).block();
            PagingProvider pagingProvider = this.getTarget().map(target -> this.getPagingProvider((Message)resultEvent.getVariable(target).getValue())).orElseGet(() -> this.getPagingProvider(resultEvent.getMessage()));
            if (pagingProvider == null) {
                throw new IllegalStateException("Obtained paging delegate cannot be null");
            }
            PagingProviderProducer producer = new PagingProviderProducer(pagingProvider, (ConfigurationInstance)operationContext.getConfiguration().get(), operationContext, this.connectionSupplier);
            ListConsumer consumer = new ListConsumer(producer);
            return Mono.just((Object)this.returnDelegate.asReturnValue(new ConsumerStreamingIterator((Consumer)consumer), operationContext));
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        catch (Throwable t) {
            return Mono.error((Throwable)Exceptions.wrapFatal((Throwable)t));
        }
    }

    private PagingProvider getPagingProvider(Message message) {
        return (PagingProvider)message.getPayload().getValue();
    }
}

