/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.model.resolvers;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleEventContext;
import org.mule.runtime.core.api.model.InvocationResult;
import org.mule.runtime.core.api.model.resolvers.AbstractEntryPointResolver;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.mule.runtime.core.routing.filters.WildcardFilter;

public class ReflectionEntryPointResolver
extends AbstractEntryPointResolver {
    private Set<String> ignoredMethods = new HashSet<String>(Arrays.asList("equals", "getInvocationHandler", "set*", "toString", "getClass", "notify", "notifyAll", "wait", "hashCode", "clone", "is*", "get*", "apply"));
    protected WildcardFilter filter;

    public ReflectionEntryPointResolver() {
        this.updateFilter();
    }

    private void updateFilter() {
        this.filter = new WildcardFilter(StringUtils.join(this.ignoredMethods, (char)','));
    }

    public Set<String> getIgnoredMethods() {
        return Collections.unmodifiableSet(this.ignoredMethods);
    }

    public void setIgnoredMethods(Set<String> methods) {
        this.ignoredMethods = new HashSet<String>(methods);
        this.updateFilter();
    }

    public void addIgnoredMethod(String name) {
        this.ignoredMethods.add(name);
        this.updateFilter();
    }

    public boolean removeIgnoredMethod(String name) {
        boolean result = this.ignoredMethods.remove(name);
        this.updateFilter();
        return result;
    }

    @Override
    public InvocationResult invoke(Object component, MuleEventContext context, Event.Builder eventBuilder) throws Exception {
        Object[] payload = this.getPayloadFromMessage(context);
        Method method = this.getMethodByArguments(component, payload);
        if (method != null) {
            return this.invokeMethod(component, method, payload);
        }
        Class<?>[] types = ClassUtils.getClassTypes(payload);
        List<Method> methods = ClassUtils.getSatisfiableMethods(component.getClass(), types, this.isAcceptVoidMethods(), false, this.ignoredMethods, this.filter);
        int numMethods = methods.size();
        if (numMethods > 1) {
            InvocationResult result = new InvocationResult(this, InvocationResult.State.FAILED);
            result.setErrorTooManyMatchingMethods(component, types, StringMessageUtils.toString(methods));
            return result;
        }
        if (numMethods == 1) {
            method = this.addMethodByArguments(component, methods.get(0), payload);
        } else {
            methods = ClassUtils.getSatisfiableMethods(component.getClass(), ClassUtils.getClassTypes(payload), true, true, this.ignoredMethods);
            numMethods = methods.size();
            if (numMethods > 1) {
                InvocationResult result = new InvocationResult(this, InvocationResult.State.FAILED);
                result.setErrorTooManyMatchingMethods(component, types, StringMessageUtils.toString(methods));
                return result;
            }
            if (numMethods == 1) {
                method = this.addMethodByArguments(component, methods.get(0), payload);
            } else {
                InvocationResult result = new InvocationResult(this, InvocationResult.State.FAILED);
                result.setErrorNoMatchingMethods(component, ClassUtils.getClassTypes(payload));
                return result;
            }
        }
        return this.invokeMethod(component, method, payload);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReflectionEntryPointResolver");
        sb.append("{ignoredMethods=").append(StringMessageUtils.toString(this.ignoredMethods));
        sb.append(", acceptVoidMethods=").append(this.isAcceptVoidMethods());
        sb.append('}');
        return sb.toString();
    }
}

