/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.context;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.context.MuleContextBuilder;
import org.mule.runtime.core.api.context.MuleContextFactory;
import org.mule.runtime.core.api.context.notification.MuleContextListener;
import org.mule.runtime.core.config.DefaultMuleConfiguration;
import org.mule.runtime.core.config.bootstrap.ArtifactType;
import org.mule.runtime.core.config.builders.AutoConfigurationBuilder;
import org.mule.runtime.core.config.builders.DefaultsConfigurationBuilder;
import org.mule.runtime.core.config.builders.SimpleConfigurationBuilder;
import org.mule.runtime.core.context.DefaultMuleContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMuleContextFactory
implements MuleContextFactory {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultMuleContextBuilder.class);
    private List<MuleContextListener> listeners = new LinkedList<MuleContextListener>();

    @Override
    public MuleContext createMuleContext() throws InitialisationException, ConfigurationException {
        return this.createMuleContext((ConfigurationBuilder)new DefaultsConfigurationBuilder(), (MuleContextBuilder)this.createMuleContextBuilder());
    }

    protected DefaultMuleContextBuilder createMuleContextBuilder() {
        return new DefaultMuleContextBuilder();
    }

    @Override
    public MuleContext createMuleContext(ConfigurationBuilder ... configurationBuilders) throws InitialisationException, ConfigurationException {
        return this.createMuleContext(Arrays.asList(configurationBuilders), (MuleContextBuilder)this.createMuleContextBuilder());
    }

    @Override
    public MuleContext createMuleContext(MuleContextBuilder muleContextBuilder) throws InitialisationException, ConfigurationException {
        return this.createMuleContext((ConfigurationBuilder)new DefaultsConfigurationBuilder(), muleContextBuilder);
    }

    @Override
    public MuleContext createMuleContext(final List<ConfigurationBuilder> configurationBuilders, MuleContextBuilder muleContextBuilder) throws InitialisationException, ConfigurationException {
        return this.doCreateMuleContext(muleContextBuilder, new ContextConfigurator(){

            @Override
            public void configure(MuleContext muleContext) throws ConfigurationException {
                for (ConfigurationBuilder configBuilder : configurationBuilders) {
                    configBuilder.configure(muleContext);
                }
                DefaultMuleContextFactory.this.notifyMuleContextConfiguration(muleContext);
            }
        });
    }

    @Override
    public MuleContext createMuleContext(final ConfigurationBuilder configurationBuilder, MuleContextBuilder muleContextBuilder) throws InitialisationException, ConfigurationException {
        return this.doCreateMuleContext(muleContextBuilder, new ContextConfigurator(){

            @Override
            public void configure(MuleContext muleContext) throws ConfigurationException {
                configurationBuilder.configure(muleContext);
                DefaultMuleContextFactory.this.notifyMuleContextConfiguration(muleContext);
            }
        });
    }

    public MuleContext createMuleContext(String resource) throws InitialisationException, ConfigurationException {
        return this.createMuleContext(resource, null);
    }

    public MuleContext createMuleContext(final String configResources, final Properties properties) throws InitialisationException, ConfigurationException {
        return this.doCreateMuleContext(this.createMuleContextBuilder(), new ContextConfigurator(){

            @Override
            public void configure(MuleContext muleContext) throws ConfigurationException {
                if (properties != null && !properties.isEmpty()) {
                    new SimpleConfigurationBuilder(properties).configure(muleContext);
                }
                new AutoConfigurationBuilder(configResources, Collections.emptyMap(), ArtifactType.APP).configure(muleContext);
                DefaultMuleContextFactory.this.notifyMuleContextConfiguration(muleContext);
            }
        });
    }

    public MuleContext createMuleContext(ConfigurationBuilder configurationBuilder, Properties properties) throws InitialisationException, ConfigurationException {
        return this.createMuleContext(configurationBuilder, properties, (MuleConfiguration)new DefaultMuleConfiguration());
    }

    public MuleContext createMuleContext(List<ConfigurationBuilder> configurationBuilders, Properties properties) throws InitialisationException, ConfigurationException {
        return this.createMuleContext(configurationBuilders, properties, (MuleConfiguration)new DefaultMuleConfiguration());
    }

    public MuleContext createMuleContext(ConfigurationBuilder configurationBuilder, Properties properties, MuleConfiguration configuration) throws InitialisationException, ConfigurationException {
        return this.createMuleContext(Collections.singletonList(configurationBuilder), properties, configuration);
    }

    public MuleContext createMuleContext(final List<ConfigurationBuilder> configurationBuilders, final Properties properties, MuleConfiguration configuration) throws InitialisationException, ConfigurationException {
        DefaultMuleContextBuilder contextBuilder = this.createMuleContextBuilder();
        contextBuilder.setMuleConfiguration(configuration);
        return this.doCreateMuleContext(contextBuilder, new ContextConfigurator(){

            @Override
            public void configure(MuleContext muleContext) throws ConfigurationException {
                if (properties != null && !properties.isEmpty()) {
                    new SimpleConfigurationBuilder(properties).configure(muleContext);
                }
                for (ConfigurationBuilder configurationBuilder : configurationBuilders) {
                    configurationBuilder.configure(muleContext);
                }
                DefaultMuleContextFactory.this.notifyMuleContextConfiguration(muleContext);
            }
        });
    }

    protected MuleContext doCreateMuleContext(MuleContextBuilder muleContextBuilder, ContextConfigurator configurator) throws InitialisationException, ConfigurationException {
        MuleContext muleContext = this.buildMuleContext(muleContextBuilder);
        this.notifyMuleContextCreation(muleContext);
        try {
            configurator.configure(muleContext);
            muleContext.initialise();
            this.notifyMuleContextInitialized(muleContext);
        }
        catch (ConfigurationException e) {
            block5: {
                if (muleContext != null && !muleContext.isDisposed()) {
                    try {
                        muleContext.dispose();
                    }
                    catch (Exception e1) {
                        logger.warn("Can not dispose context. " + ExceptionUtils.getMessage((Throwable)e1));
                        if (!logger.isDebugEnabled()) break block5;
                        logger.debug("Can not dispose context. " + ExceptionUtils.getFullStackTrace((Throwable)e1));
                    }
                }
            }
            throw e;
        }
        return muleContext;
    }

    protected MuleContext buildMuleContext(MuleContextBuilder muleContextBuilder) {
        return muleContextBuilder.buildMuleContext();
    }

    @Override
    public void addListener(MuleContextListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(MuleContextListener listener) {
        return this.listeners.remove(listener);
    }

    private void notifyMuleContextCreation(MuleContext context) {
        for (MuleContextListener listener : this.listeners) {
            listener.onCreation(context);
        }
    }

    private void notifyMuleContextInitialized(MuleContext context) {
        for (MuleContextListener listener : this.listeners) {
            listener.onInitialization(context);
        }
    }

    private void notifyMuleContextConfiguration(MuleContext context) {
        for (MuleContextListener listener : this.listeners) {
            listener.onConfiguration(context);
        }
    }

    private abstract class ContextConfigurator {
        private ContextConfigurator() {
        }

        public abstract void configure(MuleContext var1) throws ConfigurationException;
    }
}

