/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.datatype;

import java.nio.charset.Charset;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.transformer.AbstractTransformer;

public class StringToCharsetTransformer
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 1;

    public StringToCharsetTransformer() {
        this.registerSourceType(DataType.STRING);
        this.setReturnDataType(DataType.builder().type(Charset.class).build());
    }

    @Override
    protected Object doTransform(Object src, Charset enc) throws TransformerException {
        try {
            return DataType.builder().charset((String)src).build().getMediaType().getCharset().get();
        }
        catch (Exception e) {
            throw new TransformerException(I18nMessageFactory.createStaticMessage((String)"Exception transforming to Charset."), (Throwable)e);
        }
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

