/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;

final class FluxConcatIterable<T>
extends Flux<T> {
    final Iterable<? extends Publisher<? extends T>> iterable;

    FluxConcatIterable(Iterable<? extends Publisher<? extends T>> iterable) {
        this.iterable = Objects.requireNonNull(iterable, "iterable");
    }

    public void subscribe(Subscriber<? super T> s) {
        Iterator<? extends Publisher<? extends T>> it;
        try {
            it = Objects.requireNonNull(this.iterable.iterator(), "The Iterator returned is null");
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        ConcatIterableSubscriber<T> parent = new ConcatIterableSubscriber<T>(s, it);
        s.onSubscribe(parent);
        if (!parent.isCancelled()) {
            parent.onComplete();
        }
    }

    static final class ConcatIterableSubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T> {
        final Iterator<? extends Publisher<? extends T>> it;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<ConcatIterableSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(ConcatIterableSubscriber.class, "wip");
        long produced;

        ConcatIterableSubscriber(Subscriber<? super T> actual, Iterator<? extends Publisher<? extends T>> it) {
            super(actual);
            this.it = it;
        }

        public void onNext(T t) {
            ++this.produced;
            this.actual.onNext(t);
        }

        @Override
        public void onComplete() {
            if (WIP.getAndIncrement(this) == 0) {
                Iterator<Publisher<T>> a = this.it;
                do {
                    Publisher<? extends T> p;
                    boolean b;
                    if (this.isCancelled()) {
                        return;
                    }
                    try {
                        b = a.hasNext();
                    }
                    catch (Throwable e) {
                        this.onError(Operators.onOperatorError(this, e));
                        return;
                    }
                    if (this.isCancelled()) {
                        return;
                    }
                    if (!b) {
                        this.actual.onComplete();
                        return;
                    }
                    try {
                        p = Objects.requireNonNull(this.it.next(), "The Publisher returned by the iterator is null");
                    }
                    catch (Throwable e) {
                        this.actual.onError(Operators.onOperatorError(this, e));
                        return;
                    }
                    if (this.isCancelled()) {
                        return;
                    }
                    long c = this.produced;
                    if (c != 0L) {
                        this.produced = 0L;
                        this.produced(c);
                    }
                    p.subscribe((Subscriber)this);
                    if (!this.isCancelled()) continue;
                    return;
                } while (WIP.decrementAndGet(this) != 0);
            }
        }
    }
}

