/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.processors;

import org.mule.runtime.config.spring.parsers.PostProcessor;
import org.mule.runtime.config.spring.parsers.assembly.BeanAssembler;
import org.mule.runtime.config.spring.parsers.assembly.BeanAssemblerFactory;
import org.mule.runtime.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.runtime.config.spring.util.SpringXMLUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractChildElementIterator
implements PostProcessor {
    private BeanAssemblerFactory beanAssemblerFactory;
    private PropertyConfiguration configuration;

    public AbstractChildElementIterator(BeanAssemblerFactory beanAssemblerFactory, PropertyConfiguration configuration) {
        this.beanAssemblerFactory = beanAssemblerFactory;
        this.configuration = configuration;
    }

    @Override
    public void postProcess(ParserContext context, BeanAssembler assembler, Element element) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            this.processChildElement(context, assembler, element, (Element)child);
        }
    }

    protected void processChildElement(ParserContext context, BeanAssembler assembler, Element parent, Element child) {
        Object childBean = null;
        childBean = SpringXMLUtils.isBeansNamespace(child) || SpringXMLUtils.isLocalName(child, "ref") ? context.getDelegate().parsePropertySubElement(child, null) : context.getDelegate().parseCustomElement(child, (BeanDefinition)assembler.getBean().getBeanDefinition());
        BeanAssembler targetAssembler = this.beanAssemblerFactory.newBeanAssembler(null, null, this.configuration, (BeanDefinition)assembler.getBean().getRawBeanDefinition());
        this.insertBean(targetAssembler, childBean, parent, child);
    }

    protected abstract void insertBean(BeanAssembler var1, Object var2, Element var3, Element var4);
}

