/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.runtime.core.config.bootstrap.ArtifactType;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginRepository;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.descriptor.BundleDescriptorLoader;
import org.mule.runtime.module.artifact.descriptor.BundleScope;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.artifact.util.FileJarExplorer;
import org.mule.runtime.module.artifact.util.JarInfo;
import org.mule.runtime.module.deployment.impl.internal.application.EmptyApplicationDescriptor;
import org.mule.runtime.module.deployment.impl.internal.application.PropertiesDescriptorParser;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactoryUtils;
import org.mule.runtime.module.deployment.impl.internal.artifact.DescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.artifact.LoaderNotFoundException;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDescriptorFactory
implements ArtifactDescriptorFactory<ApplicationDescriptor> {
    public static final String SYSTEM_PROPERTY_OVERRIDE = "-O";
    private static final String UNKNOWN = "unknown";
    private static final Logger logger = LoggerFactory.getLogger(ApplicationDescriptorFactory.class);
    private static final String MULE_CONFIG_FILES_FOLDER = "mule";
    private final ArtifactPluginRepository applicationPluginRepository;
    private final ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader;
    private final DescriptorLoaderRepository descriptorLoaderRepository;

    public ApplicationDescriptorFactory(ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader, ArtifactPluginRepository applicationPluginRepository, DescriptorLoaderRepository descriptorLoaderRepository) {
        Preconditions.checkArgument((artifactPluginDescriptorLoader != null ? 1 : 0) != 0, (String)"ApplicationPluginDescriptorFactory cannot be null");
        Preconditions.checkArgument((applicationPluginRepository != null ? 1 : 0) != 0, (String)"ApplicationPluginRepository cannot be null");
        this.applicationPluginRepository = applicationPluginRepository;
        this.artifactPluginDescriptorLoader = artifactPluginDescriptorLoader;
        this.descriptorLoaderRepository = descriptorLoaderRepository;
    }

    public ApplicationDescriptor create(File artifactFolder) throws ArtifactDescriptorCreateException {
        File mulePluginJsonFile = new File(artifactFolder, ArtifactPluginDescriptor.MULE_ARTIFACT_FOLDER + File.separator + "mule-application.json");
        ApplicationDescriptor applicationDescriptor = mulePluginJsonFile.exists() ? this.loadFromJsonDescriptor(artifactFolder, mulePluginJsonFile) : this.createFromProperties(artifactFolder);
        return applicationDescriptor;
    }

    protected static String invalidClassLoaderModelIdError(File pluginFolder, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor) {
        return String.format("The identifier '%s' for a class loader model descriptor is not supported (error found while reading plugin '%s')", classLoaderModelLoaderDescriptor.getId(), pluginFolder.getAbsolutePath());
    }

    private BundleDescriptor getBundleDescriptor(File appFolder, MuleApplicationModel muleApplicationModel) {
        BundleDescriptorLoader bundleDescriptorLoader;
        try {
            bundleDescriptorLoader = this.descriptorLoaderRepository.get(muleApplicationModel.getBundleDescriptorLoader().getId(), ArtifactType.APP, BundleDescriptorLoader.class);
        }
        catch (LoaderNotFoundException e) {
            throw new ArtifactDescriptorCreateException(ApplicationDescriptorFactory.invalidBundleDescriptorLoaderIdError(appFolder, muleApplicationModel.getBundleDescriptorLoader()));
        }
        try {
            return (BundleDescriptor)bundleDescriptorLoader.load(appFolder, muleApplicationModel.getBundleDescriptorLoader().getAttributes(), ArtifactType.APP);
        }
        catch (InvalidDescriptorLoaderException e) {
            throw new ArtifactDescriptorCreateException((Throwable)e);
        }
    }

    protected static String invalidBundleDescriptorLoaderIdError(File pluginFolder, MuleArtifactLoaderDescriptor bundleDescriptorLoader) {
        return String.format("The identifier '%s' for a bundle descriptor loader is not supported (error found while reading plugin '%s')", bundleDescriptorLoader.getId(), pluginFolder.getAbsolutePath());
    }

    private ApplicationDescriptor loadFromJsonDescriptor(File applicationFolder, File muleApplicationJsonFile) {
        MuleApplicationModel muleApplicationModel = this.getMuleApplicationJsonDescriber(muleApplicationJsonFile);
        ApplicationDescriptor descriptor = new ApplicationDescriptor(applicationFolder.getName());
        descriptor.setArtifactLocation(applicationFolder);
        descriptor.setRootFolder(applicationFolder);
        descriptor.setBundleDescriptor(this.getBundleDescriptor(applicationFolder, muleApplicationModel));
        descriptor.setMinMuleVersion(new MuleVersion(muleApplicationModel.getMinMuleVersion()));
        muleApplicationModel.getDomain().ifPresent(domain -> descriptor.setDomain(domain));
        List muleApplicationModelConfigs = muleApplicationModel.getConfigs();
        if (muleApplicationModelConfigs != null && !muleApplicationModelConfigs.isEmpty()) {
            descriptor.setConfigResources(muleApplicationModelConfigs.stream().map(configFile -> this.appendMuleFolder((String)configFile)).collect(Collectors.toList()));
            List<File> configFiles = descriptor.getConfigResources().stream().map(config -> new File(applicationFolder, (String)config)).collect(Collectors.toList());
            descriptor.setConfigResourcesFile(configFiles.toArray(new File[configFiles.size()]));
            descriptor.setAbsoluteResourcePaths(configFiles.stream().map(configFile -> configFile.getAbsolutePath()).collect(Collectors.toList()).toArray(new String[configFiles.size()]));
        } else {
            File configFile2 = new File(applicationFolder, this.appendMuleFolder("mule-config.xml"));
            descriptor.setConfigResourcesFile(new File[]{configFile2});
            descriptor.setConfigResources((List)ImmutableList.builder().add((Object)ApplicationDescriptor.DEFAULT_CONFIGURATION_RESOURCE_LOCATION).build());
            descriptor.setAbsoluteResourcePaths(new String[]{configFile2.getAbsolutePath()});
        }
        muleApplicationModel.getClassLoaderModelLoaderDescriptor().ifPresent(classLoaderModelLoaderDescriptor -> {
            ClassLoaderModel classLoaderModel = this.getClassLoaderModel(applicationFolder, (MuleArtifactLoaderDescriptor)classLoaderModelLoaderDescriptor);
            descriptor.setClassLoaderModel(classLoaderModel);
            try {
                descriptor.setPlugins(this.createArtifactPluginDescriptors(classLoaderModel));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
        File appClassesFolder = this.getAppClassesFolder(descriptor);
        this.setApplicationProperties(descriptor, new File(appClassesFolder, "mule-artifact.properties"));
        return descriptor;
    }

    private String appendMuleFolder(String configFile) {
        return MULE_CONFIG_FILES_FOLDER + File.separator + configFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MuleApplicationModel getMuleApplicationJsonDescriber(File jsonFile) {
        try (FileInputStream stream = new FileInputStream(jsonFile);){
            MuleApplicationModel muleApplicationModel = (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(IOUtils.toString((InputStream)stream));
            return muleApplicationModel;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Could not read extension describer on plugin '%s'", jsonFile.getAbsolutePath()), e);
        }
    }

    private ClassLoaderModel getClassLoaderModel(File applicationFolder, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor) {
        ClassLoaderModel classLoaderModel;
        ClassLoaderModelLoader classLoaderModelLoader;
        try {
            classLoaderModelLoader = this.descriptorLoaderRepository.get(classLoaderModelLoaderDescriptor.getId(), ArtifactType.APP, ClassLoaderModelLoader.class);
        }
        catch (LoaderNotFoundException e) {
            throw new ArtifactDescriptorCreateException(ApplicationDescriptorFactory.invalidClassLoaderModelIdError(applicationFolder, classLoaderModelLoaderDescriptor));
        }
        try {
            classLoaderModel = (ClassLoaderModel)classLoaderModelLoader.load(applicationFolder, classLoaderModelLoaderDescriptor.getAttributes(), ArtifactType.APP);
        }
        catch (InvalidDescriptorLoaderException e) {
            throw new ArtifactDescriptorCreateException((Throwable)e);
        }
        return classLoaderModel;
    }

    public ApplicationDescriptor createFromProperties(File artifactFolder) throws ArtifactDescriptorCreateException {
        EmptyApplicationDescriptor desc;
        if (!artifactFolder.exists()) {
            throw new IllegalArgumentException(String.format("Application directory does not exist: '%s'", artifactFolder));
        }
        String appName = artifactFolder.getName();
        try {
            File deployPropertiesFile = ArtifactFactoryUtils.getDeploymentFile(artifactFolder);
            if (deployPropertiesFile != null) {
                PropertiesDescriptorParser descriptorParser = new PropertiesDescriptorParser();
                desc = descriptorParser.parse(artifactFolder, deployPropertiesFile, appName);
            } else {
                desc = new EmptyApplicationDescriptor(artifactFolder);
            }
            File appClassesFolder = this.getAppClassesFolder(desc);
            URL[] libraries = this.findLibraries(desc);
            URL[] sharedLibraries = this.findSharedLibraries(desc);
            this.setApplicationProperties(desc, new File(appClassesFolder, "mule-artifact.properties"));
            List<URL> urls = this.getApplicationResourceUrls(appClassesFolder.toURI().toURL(), libraries, sharedLibraries);
            if (!urls.isEmpty() && logger.isInfoEnabled()) {
                this.logArtifactRuntimeUrls(appName, urls);
            }
            ClassLoaderModel.ClassLoaderModelBuilder classLoaderModelBuilder = new ClassLoaderModel.ClassLoaderModelBuilder();
            for (URL url : urls) {
                classLoaderModelBuilder.containing(url);
            }
            JarInfo jarInfo = this.findApplicationResources(desc, sharedLibraries);
            classLoaderModelBuilder.exportingPackages(jarInfo.getPackages()).exportingResources(jarInfo.getResources());
            classLoaderModelBuilder.dependingOn(this.getPluginDependencies(artifactFolder));
            ClassLoaderModel classLoaderModel = classLoaderModelBuilder.build();
            desc.setClassLoaderModel(classLoaderModel);
            desc.setPlugins(this.createArtifactPluginDescriptors(classLoaderModel));
        }
        catch (IOException e) {
            throw new ArtifactDescriptorCreateException("Unable to create application descriptor", (Throwable)e);
        }
        return desc;
    }

    private Set<BundleDependency> getPluginDependencies(File applicationFolder) throws MalformedURLException {
        HashSet<BundleDependency> plugins = new HashSet<BundleDependency>();
        File pluginsFolders = new File(applicationFolder, "plugins");
        if (pluginsFolders.exists()) {
            File[] files = pluginsFolders.listFiles();
            if (!pluginsFolders.exists()) {
                return plugins;
            }
            BundleDescriptor bundleDescriptor = new BundleDescriptor.Builder().setArtifactId(UNKNOWN).setGroupId(UNKNOWN).setVersion(UNKNOWN).setClassifier("mule-plugin").build();
            for (File file : files) {
                plugins.add(new BundleDependency.Builder().setBundleUri(file.toURI()).setScope(BundleScope.COMPILE).setDescriptor(bundleDescriptor).build());
            }
        }
        return plugins;
    }

    private Set<ArtifactPluginDescriptor> createArtifactPluginDescriptors(ClassLoaderModel classLoaderModel) throws IOException {
        HashSet<ArtifactPluginDescriptor> pluginDescriptors = new HashSet<ArtifactPluginDescriptor>();
        for (BundleDependency bundleDependency : classLoaderModel.getDependencies()) {
            if (!bundleDependency.getDescriptor().isPlugin()) continue;
            File pluginFile = new File(bundleDependency.getBundleUri());
            pluginDescriptors.add(this.artifactPluginDescriptorLoader.load(pluginFile));
        }
        return pluginDescriptors;
    }

    private URL[] findLibraries(ApplicationDescriptor descriptor) throws MalformedURLException {
        return this.findJars(this.getAppLibFolder(descriptor)).toArray(new URL[0]);
    }

    protected File getAppLibFolder(ApplicationDescriptor descriptor) {
        return MuleFoldersUtil.getAppLibFolder((String)descriptor.getName());
    }

    private URL[] findSharedLibraries(ApplicationDescriptor descriptor) throws MalformedURLException {
        return this.findJars(this.getAppSharedLibsFolder(descriptor)).toArray(new URL[0]);
    }

    protected File getAppSharedLibsFolder(ApplicationDescriptor descriptor) {
        return MuleFoldersUtil.getAppSharedLibsFolder((String)descriptor.getName());
    }

    private JarInfo findApplicationResources(ApplicationDescriptor descriptor, URL[] sharedLibraries) {
        JarInfo classesInfo;
        JarInfo librariesInfo = this.findExportedResources(sharedLibraries);
        try {
            File appClassesFolder = this.getAppClassesFolder(descriptor);
            classesInfo = appClassesFolder.exists() ? this.findExportedResources(appClassesFolder.toURI().toURL()) : new JarInfo(Collections.emptySet(), Collections.emptySet());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot read application classes folder", e);
        }
        librariesInfo.getPackages().addAll(classesInfo.getPackages());
        librariesInfo.getResources().addAll(classesInfo.getResources());
        return librariesInfo;
    }

    protected File getAppClassesFolder(ApplicationDescriptor descriptor) {
        return MuleFoldersUtil.getAppClassesFolder((String)descriptor.getName());
    }

    private JarInfo findExportedResources(URL ... libraries) {
        HashSet packages = new HashSet();
        HashSet resources = new HashSet();
        FileJarExplorer jarExplorer = new FileJarExplorer();
        for (URL library : libraries) {
            try {
                JarInfo jarInfo = jarExplorer.explore(library.toURI());
                packages.addAll(jarInfo.getPackages());
                resources.addAll(jarInfo.getResources());
            }
            catch (URISyntaxException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return new JarInfo(packages, resources);
    }

    protected List<URL> findJars(File dir) throws MalformedURLException {
        LinkedList<URL> result = new LinkedList<URL>();
        if (dir.exists() && dir.canRead()) {
            Collection jars = FileUtils.listFiles((File)dir, (String[])new String[]{"jar"}, (boolean)false);
            for (File jar : jars) {
                result.add(jar.toURI().toURL());
            }
        }
        return result;
    }

    private List<ArtifactPluginDescriptor> getAllApplicationPlugins(Set<ArtifactPluginDescriptor> plugins) {
        LinkedList<ArtifactPluginDescriptor> result = new LinkedList<ArtifactPluginDescriptor>(this.applicationPluginRepository.getContainerArtifactPluginDescriptors());
        result.addAll(plugins);
        result.sort((descriptor1, descriptor2) -> descriptor1.getName().compareTo(descriptor2.getName()));
        return result;
    }

    public void setApplicationProperties(ApplicationDescriptor desc, File appPropsFile) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (appPropsFile.exists() && appPropsFile.canRead()) {
            Properties props;
            try {
                props = PropertiesUtils.loadProperties((URL)appPropsFile.toURI().toURL());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to obtain application properties file URL", e);
            }
            for (Object key : props.keySet()) {
                m.put(key.toString(), props.getProperty(key.toString()));
            }
        }
        Properties sysProps = System.getProperties();
        for (Map.Entry<Object, Object> entry : sysProps.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(SYSTEM_PROPERTY_OVERRIDE)) continue;
            m.put(key.substring(SYSTEM_PROPERTY_OVERRIDE.length()), entry.getValue().toString());
        }
        desc.setAppProperties(m);
    }

    private List<URL> getApplicationResourceUrls(URL classesFolderUrl, URL[] libraries, URL[] sharedLibraries) {
        LinkedList<URL> urls = new LinkedList<URL>();
        urls.add(classesFolderUrl);
        for (URL url : libraries) {
            urls.add(url);
        }
        for (URL url : sharedLibraries) {
            urls.add(url);
        }
        return urls;
    }

    private void logArtifactRuntimeUrls(String appName, List<URL> urls) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("[%s] Loading the following jars:%n", appName));
        sb.append("=============================").append(SystemUtils.LINE_SEPARATOR);
        for (URL url : urls) {
            sb.append(url).append(SystemUtils.LINE_SEPARATOR);
        }
        sb.append("=============================").append(SystemUtils.LINE_SEPARATOR);
        logger.info(sb.toString());
    }
}

