/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;

final class FluxDetach<T>
extends FluxSource<T, T> {
    FluxDetach(Flux<? extends T> source) {
        super(source);
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new DetachSubscriber<T>(s));
    }

    static final class DetachSubscriber<T>
    implements InnerOperator<T, T> {
        Subscriber<? super T> actual;
        Subscription s;

        DetachSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case TERMINATED: {
                    return this.actual == null;
                }
                case CANCELLED: {
                    return this.actual == null && this.s == null;
                }
            }
            return InnerOperator.super.scan(key);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            Subscriber<? super T> a = this.actual;
            if (a != null) {
                a.onNext(t);
            }
        }

        public void onError(Throwable t) {
            Subscriber<? super T> a = this.actual;
            if (a != null) {
                this.actual = null;
                this.s = null;
                a.onError(t);
            }
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        public void onComplete() {
            Subscriber<? super T> a = this.actual;
            if (a != null) {
                this.actual = null;
                this.s = null;
                a.onComplete();
            }
        }

        public void request(long n) {
            Subscription a = this.s;
            if (a != null) {
                a.request(n);
            }
        }

        public void cancel() {
            Subscription a = this.s;
            if (a != null) {
                this.actual = null;
                this.s = null;
                a.cancel();
            }
        }
    }
}

