/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Fold;
import net.sf.saxon.functions.FoldingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public class Count
extends FoldingFunction {
    public IntegerValue[] getIntegerBounds() {
        return new IntegerValue[]{Int64Value.ZERO, Expression.MAX_SEQUENCE_LENGTH};
    }

    public Fold getFold(XPathContext context, Sequence ... additionalArguments) throws XPathException {
        return new CountFold();
    }

    public static int count(SequenceIterator iter) throws XPathException {
        if ((iter.getProperties() & 2) != 0) {
            return ((LastPositionFinder)((Object)iter)).getLength();
        }
        int n = 0;
        while (iter.next() != null) {
            ++n;
        }
        return n;
    }

    public IntegerValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        return new Int64Value(Count.count(arguments[0].iterate()));
    }

    private class CountFold
    implements Fold {
        private int count = 0;

        public void processItem(Item item) throws XPathException {
            ++this.count;
        }

        public boolean isFinished() {
            return false;
        }

        public IntegerValue result() throws XPathException {
            return Int64Value.makeIntegerValue(this.count);
        }
    }
}

