/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.trie;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Option<T>
implements Iterable<T> {
    private static None NONE = new None();

    public abstract T get();

    public abstract boolean isDefined();

    public final T getOrElse(T defaultVal) {
        return this.isDefined() ? this.get() : defaultVal;
    }

    @Override
    public Iterator<T> iterator() {
        return this.isDefined() ? Collections.singleton(this.get()).iterator() : Collections.emptySet().iterator();
    }

    public static <T> Option<T> option(T value) {
        if (value == null) {
            return Option.none();
        }
        return Option.some(value);
    }

    public static <T> Option<T> none() {
        return NONE;
    }

    public static <T> Option<T> some(T value) {
        return new Some<T>(value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Some<T>
    extends Option<T> {
        private final T value;

        public Some(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public boolean isDefined() {
            return true;
        }

        public String toString() {
            return "Some(" + this.value + ")";
        }

        public boolean equals(Object other) {
            return other instanceof Some && ((Some)other).value.equals(this.value);
        }
    }

    private static class None
    extends Option {
        private None() {
        }

        public Object get() {
            throw new NoSuchElementException("get() called on None");
        }

        public boolean isDefined() {
            return false;
        }

        public String toString() {
            return "None";
        }
    }
}

