/*
 * Decompiled with CFR 0.152.
 */
package reactor.core;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class Exceptions {
    @Deprecated
    public static final boolean CANCEL_STACKTRACE = true;
    public static final Throwable TERMINATED = new Throwable("No further exceptions");

    public static <T> boolean addThrowable(AtomicReferenceFieldUpdater<T, Throwable> field, T instance, Throwable exception) {
        Throwable update;
        Throwable current;
        do {
            if ((current = field.get(instance)) == TERMINATED) {
                return false;
            }
            if (current == null) {
                update = exception;
                continue;
            }
            update = new Throwable("Multiple exceptions");
            update.addSuppressed(current);
            update.addSuppressed(exception);
        } while (!field.compareAndSet(instance, current, update));
        return true;
    }

    public static NullPointerException argumentIsNullException() {
        return new NullPointerException("Spec 2.13: Signal/argument cannot be null");
    }

    public static RuntimeException bubble(Throwable t) {
        Exceptions.throwIfFatal(t);
        return new BubblingException(t);
    }

    public static IllegalStateException duplicateOnSubscribeException() {
        return new IllegalStateException("Spec. Rule 2.12 - Subscriber.onSubscribe MUST NOT be called more than once (based on object equality)");
    }

    public static UnsupportedOperationException errorCallbackNotImplemented(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        return new ErrorCallbackNotImplemented(cause);
    }

    public static RuntimeException failWithCancel() {
        return new CancelException();
    }

    public static IllegalStateException failWithOverflow() {
        return new OverflowException("The receiver is overrun by more signals than expected (bounded queue...)");
    }

    public static IllegalStateException failWithOverflow(String message) {
        return new OverflowException(message);
    }

    public static boolean isOverflow(Throwable t) {
        return t instanceof OverflowException;
    }

    public static boolean isBubbling(Throwable t) {
        return t instanceof BubblingException;
    }

    public static boolean isCancel(Throwable t) {
        return t instanceof CancelException;
    }

    public static boolean isErrorCallbackNotImplemented(Throwable cause) {
        return cause != null && cause.getClass().equals(ErrorCallbackNotImplemented.class);
    }

    public static IllegalArgumentException nullOrNegativeRequestException(long elements) {
        return new IllegalArgumentException("Spec. Rule 3.9 - Cannot request a non strictly positive number: " + elements);
    }

    public static RuntimeException propagate(Throwable t) {
        Exceptions.throwIfFatal(t);
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new ReactiveException(t);
    }

    public static <T> Throwable terminate(AtomicReferenceFieldUpdater<T, Throwable> field, T instance) {
        Throwable current = field.get(instance);
        if (current != TERMINATED) {
            current = field.getAndSet(instance, TERMINATED);
        }
        return current;
    }

    public static void throwIfFatal(Throwable t) {
        if (t instanceof BubblingException) {
            throw (BubblingException)t;
        }
        if (t instanceof ErrorCallbackNotImplemented) {
            throw (ErrorCallbackNotImplemented)t;
        }
        Exceptions.throwIfJvmFatal(t);
    }

    public static void throwIfJvmFatal(Throwable t) {
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof LinkageError) {
            throw (LinkageError)t;
        }
    }

    public static Throwable unwrap(Throwable t) {
        Throwable _t = t;
        while (_t instanceof ReactiveException) {
            _t = _t.getCause();
        }
        return _t;
    }

    Exceptions() {
    }

    static final class OverflowException
    extends IllegalStateException {
        OverflowException(String s) {
            super(s);
        }
    }

    static final class CancelException
    extends BubblingException {
        private static final long serialVersionUID = 2491425227432776144L;

        CancelException() {
            super("The subscriber has denied dispatching");
        }
    }

    static final class ErrorCallbackNotImplemented
    extends UnsupportedOperationException {
        private static final long serialVersionUID = 2491425227432776143L;

        ErrorCallbackNotImplemented(Throwable cause) {
            super(cause);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    static class ReactiveException
    extends RuntimeException {
        private static final long serialVersionUID = 2491425227432776143L;

        ReactiveException(Throwable cause) {
            super(cause);
        }

        ReactiveException(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this.getCause() != null ? this.getCause().fillInStackTrace() : super.fillInStackTrace();
        }
    }

    static class BubblingException
    extends ReactiveException {
        private static final long serialVersionUID = 2491425277432776142L;

        BubblingException(String message) {
            super(message);
        }

        BubblingException(Throwable cause) {
            super(cause);
        }
    }
}

