/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.InnerConsumer;

abstract class BlockingSingleSubscriber<T>
extends CountDownLatch
implements InnerConsumer<T>,
Disposable {
    T value;
    Throwable error;
    Subscription s;
    volatile boolean cancelled;

    BlockingSingleSubscriber() {
        super(1);
    }

    public final void onSubscribe(Subscription s) {
        this.s = s;
        if (!this.cancelled) {
            s.request(Long.MAX_VALUE);
        }
    }

    public final void onComplete() {
        this.countDown();
    }

    @Override
    public final void dispose() {
        this.cancelled = true;
        Subscription s = this.s;
        if (s != null) {
            this.s = null;
            s.cancel();
        }
    }

    final T blockingGet() {
        Throwable e;
        if (this.getCount() != 0L) {
            try {
                this.await();
            }
            catch (InterruptedException ex) {
                this.dispose();
                throw Exceptions.propagate(ex);
            }
        }
        if ((e = this.error) != null) {
            RuntimeException re = Exceptions.propagate(e);
            re.addSuppressed(new Exception("#block terminated with an error"));
            throw re;
        }
        return this.value;
    }

    final T blockingGet(long timeout, TimeUnit unit) {
        Throwable e;
        if (this.getCount() != 0L) {
            try {
                if (!this.await(timeout, unit)) {
                    this.dispose();
                    throw new IllegalStateException("Timeout on blocking read for " + timeout + " " + (Object)((Object)unit));
                }
            }
            catch (InterruptedException ex) {
                this.dispose();
                RuntimeException re = Exceptions.propagate(ex);
                re.addSuppressed(new Exception("#block has been interrupted"));
                throw re;
            }
        }
        if ((e = this.error) != null) {
            RuntimeException re = Exceptions.propagate(e);
            re.addSuppressed(new Exception("#block terminated with an error"));
            throw re;
        }
        return this.value;
    }

    @Override
    public Object scan(Scannable.Attr key) {
        switch (key) {
            case TERMINATED: {
                return this.getCount() == 0L;
            }
            case PARENT: {
                return this.s;
            }
            case CANCELLED: {
                return this.cancelled;
            }
            case ERROR: {
                return this.error;
            }
            case PREFETCH: {
                return Integer.MAX_VALUE;
            }
        }
        return null;
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled || this.getCount() == 0L;
    }
}

