/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;

final class FluxDefer<T>
extends Flux<T> {
    final Supplier<? extends Publisher<? extends T>> supplier;

    FluxDefer(Supplier<? extends Publisher<? extends T>> supplier) {
        this.supplier = Objects.requireNonNull(supplier, "supplier");
    }

    public void subscribe(Subscriber<? super T> s) {
        Publisher<? extends T> p;
        try {
            p = Objects.requireNonNull(this.supplier.get(), "The Publisher returned by the supplier is null");
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        p.subscribe(s);
    }
}

