/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SynchronousSink;

final class FluxHandle<T, R>
extends FluxSource<T, R> {
    final BiConsumer<? super T, SynchronousSink<R>> handler;

    FluxHandle(Flux<? extends T> source, BiConsumer<? super T, SynchronousSink<R>> handler) {
        super(source);
        this.handler = Objects.requireNonNull(handler, "handler");
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        if (s instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)s;
            this.source.subscribe(new HandleConditionalSubscriber<T, R>(cs, this.handler));
            return;
        }
        this.source.subscribe(new HandleSubscriber<T, R>(s, this.handler));
    }

    static final class HandleConditionalSubscriber<T, R>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, R>,
    SynchronousSink<R> {
        final Fuseable.ConditionalSubscriber<? super R> actual;
        final BiConsumer<? super T, SynchronousSink<R>> handler;
        boolean done;
        Throwable error;
        R data;
        Subscription s;

        HandleConditionalSubscriber(Fuseable.ConditionalSubscriber<? super R> actual, BiConsumer<? super T, SynchronousSink<R>> handler) {
            this.actual = actual;
            this.handler = handler;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            try {
                this.handler.accept(t, this);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            R v = this.data;
            this.data = null;
            if (v != null) {
                this.actual.onNext(v);
            }
            if (this.done) {
                this.s.cancel();
                if (this.error != null) {
                    this.actual.onError(Operators.onOperatorError(null, this.error, t));
                    return;
                }
                this.actual.onComplete();
            } else if (v == null) {
                this.s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return false;
            }
            try {
                this.handler.accept(t, this);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return false;
            }
            R v = this.data;
            boolean emit = false;
            this.data = null;
            if (v != null) {
                emit = this.actual.tryOnNext(v);
            }
            if (this.done) {
                this.s.cancel();
                if (this.error != null) {
                    this.actual.onError(Operators.onOperatorError(null, this.error, t));
                } else {
                    this.actual.onComplete();
                }
                return true;
            }
            return emit;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public Subscriber<? super R> actual() {
            return this.actual;
        }

        @Override
        public void complete() {
            this.done = true;
        }

        @Override
        public void error(Throwable e) {
            this.error = Objects.requireNonNull(e, "error");
            this.done = true;
        }

        @Override
        public void next(R o) {
            if (this.data != null) {
                throw new IllegalStateException("Cannot emit more than one data");
            }
            this.data = Objects.requireNonNull(o, "data");
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case TERMINATED: {
                    return this.done;
                }
                case ERROR: {
                    return this.error;
                }
            }
            return InnerOperator.super.scan(key);
        }
    }

    static final class HandleSubscriber<T, R>
    implements InnerOperator<T, R>,
    Fuseable.ConditionalSubscriber<T>,
    SynchronousSink<R> {
        final Subscriber<? super R> actual;
        final BiConsumer<? super T, SynchronousSink<R>> handler;
        boolean done;
        boolean stop;
        Throwable error;
        R data;
        Subscription s;

        HandleSubscriber(Subscriber<? super R> actual, BiConsumer<? super T, SynchronousSink<R>> handler) {
            this.actual = actual;
            this.handler = handler;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            try {
                this.handler.accept(t, this);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            R v = this.data;
            this.data = null;
            if (v != null) {
                this.actual.onNext(v);
            }
            if (this.stop) {
                this.s.cancel();
                if (this.error != null) {
                    this.onError(Operators.onOperatorError(null, this.error, t));
                    return;
                }
                this.onComplete();
            } else if (v == null) {
                this.s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return false;
            }
            try {
                this.handler.accept(t, this);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return false;
            }
            R v = this.data;
            this.data = null;
            if (v != null) {
                this.actual.onNext(v);
            }
            if (this.stop) {
                this.s.cancel();
                if (this.error != null) {
                    this.onError(Operators.onOperatorError(null, this.error, t));
                } else {
                    this.onComplete();
                }
                return true;
            }
            return v != null;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public void complete() {
            this.stop = true;
        }

        @Override
        public void error(Throwable e) {
            this.error = Objects.requireNonNull(e, "error");
            this.stop = true;
        }

        @Override
        public void next(R o) {
            if (this.data != null) {
                throw new IllegalStateException("Cannot emit more than one data");
            }
            this.data = Objects.requireNonNull(o, "data");
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case TERMINATED: {
                    return this.done;
                }
                case ERROR: {
                    return this.error;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Subscriber<? super R> actual() {
            return this.actual;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

