/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxBatch;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.UnicastProcessor;
import reactor.core.scheduler.Scheduler;

final class FluxWindowTimeOrSize<T>
extends FluxBatch<T, Flux<T>> {
    FluxWindowTimeOrSize(Flux<T> source, int backlog, long timespan, Scheduler timer) {
        super(source, backlog, timespan, timer);
    }

    @Override
    public void subscribe(Subscriber<? super Flux<T>> subscriber) {
        this.source.subscribe(new WindowTimeoutSubscriber(this.prepareSub(subscriber), this.batchSize, this.timespan, this.timer));
    }

    static final class WindowTimeoutSubscriber<T>
    extends FluxBatch.BatchSubscriber<T, Flux<T>> {
        final Scheduler timer;
        Window<T> currentWindow;

        WindowTimeoutSubscriber(Subscriber<? super Flux<T>> actual, int backlog, long timespan, Scheduler timer) {
            super(actual, backlog, true, timespan, timer.createWorker());
            this.timer = timer;
        }

        @Override
        void doOnSubscribe() {
        }

        Flux<T> createWindowStream() {
            Window _currentWindow = new Window(this.timer);
            this.currentWindow = _currentWindow;
            return _currentWindow;
        }

        @Override
        protected void checkedError(Throwable ev) {
            if (this.currentWindow != null) {
                this.currentWindow.onError(ev);
            }
            super.checkedError(ev);
        }

        @Override
        protected void checkedComplete() {
            try {
                if (this.currentWindow != null) {
                    this.currentWindow.onComplete();
                    this.currentWindow = null;
                }
            }
            finally {
                super.checkedComplete();
            }
        }

        @Override
        protected void firstCallback(T event) {
            this.actual.onNext(this.createWindowStream());
        }

        @Override
        protected void nextCallback(T event) {
            if (this.currentWindow != null) {
                this.currentWindow.onNext(event);
            }
        }

        @Override
        protected void flushCallback(T event) {
            if (this.currentWindow != null) {
                this.currentWindow.onComplete();
            }
        }
    }

    static final class Window<T>
    extends Flux<T>
    implements InnerOperator<T, T> {
        final UnicastProcessor<T> processor = UnicastProcessor.create();
        final Scheduler timer;
        int count = 0;

        Window(Scheduler timer) {
            this.timer = timer;
        }

        public void onSubscribe(Subscription s) {
        }

        public void onNext(T t) {
            ++this.count;
            this.processor.onNext(t);
        }

        public void onError(Throwable t) {
            this.processor.onError(t);
        }

        public void onComplete() {
            this.processor.onComplete();
        }

        public void subscribe(Subscriber<? super T> s) {
            this.processor.subscribe(s);
        }

        public void request(long n) {
        }

        public void cancel() {
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.processor;
        }
    }
}

