/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.FluxHandle;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.SynchronousSink;

final class MonoHandle<T, R>
extends MonoSource<T, R> {
    final BiConsumer<? super T, SynchronousSink<R>> handler;

    MonoHandle(Mono<? extends T> source, BiConsumer<? super T, SynchronousSink<R>> handler) {
        super(source);
        this.handler = Objects.requireNonNull(handler, "handler");
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        this.source.subscribe(new FluxHandle.HandleSubscriber<T, R>(s, this.handler));
    }
}

