/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.EventLoopProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Operators;
import reactor.core.publisher.RingBuffer;
import reactor.core.publisher.TopicProcessor;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.concurrent.QueueSupplier;
import reactor.util.concurrent.WaitStrategy;

public final class WorkQueueProcessor<E>
extends EventLoopProcessor<E> {
    static final Supplier FACTORY = EventLoopProcessor.Slot::new;
    final RingBuffer.Sequence workSequence = RingBuffer.newSequence(-1L);
    final Queue<Object> claimedDisposed = new ConcurrentLinkedQueue<Object>();
    final ExecutorService requestTaskExecutor;
    final WaitStrategy writeWait;
    volatile int replaying;
    static final AtomicIntegerFieldUpdater<WorkQueueProcessor> REPLAYING = AtomicIntegerFieldUpdater.newUpdater(WorkQueueProcessor.class, "replaying");
    static final Logger log = Loggers.getLogger(WorkQueueProcessor.class);

    public static <E> WorkQueueProcessor<E> create() {
        return WorkQueueProcessor.create(WorkQueueProcessor.class.getSimpleName(), QueueSupplier.SMALL_BUFFER_SIZE, null, true);
    }

    public static <E> WorkQueueProcessor<E> create(boolean autoCancel) {
        return WorkQueueProcessor.create(WorkQueueProcessor.class.getSimpleName(), QueueSupplier.SMALL_BUFFER_SIZE, null, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> create(ExecutorService service) {
        return WorkQueueProcessor.create(service, QueueSupplier.SMALL_BUFFER_SIZE, null, true);
    }

    public static <E> WorkQueueProcessor<E> create(ExecutorService service, boolean autoCancel) {
        return WorkQueueProcessor.create(service, QueueSupplier.SMALL_BUFFER_SIZE, null, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> create(String name) {
        return WorkQueueProcessor.create(name, QueueSupplier.SMALL_BUFFER_SIZE);
    }

    public static <E> WorkQueueProcessor<E> create(String name, int bufferSize) {
        return WorkQueueProcessor.create(name, bufferSize, null, true);
    }

    public static <E> WorkQueueProcessor<E> create(String name, int bufferSize, boolean autoCancel) {
        return WorkQueueProcessor.create(name, bufferSize, null, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> create(ExecutorService service, int bufferSize) {
        return WorkQueueProcessor.create(service, bufferSize, null, true);
    }

    public static <E> WorkQueueProcessor<E> create(ExecutorService service, int bufferSize, boolean autoCancel) {
        return WorkQueueProcessor.create(service, bufferSize, null, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> create(String name, int bufferSize, WaitStrategy strategy) {
        return WorkQueueProcessor.create(name, bufferSize, strategy, true);
    }

    public static <E> WorkQueueProcessor<E> create(String name, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new WorkQueueProcessor<E>(name, bufferSize, strategy == null ? WaitStrategy.liteBlocking() : strategy, false, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> create(ExecutorService executor, int bufferSize, WaitStrategy strategy) {
        return WorkQueueProcessor.create(executor, bufferSize, strategy, true);
    }

    public static <E> WorkQueueProcessor<E> create(ExecutorService executor, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new WorkQueueProcessor<E>(null, executor, bufferSize, strategy == null ? WaitStrategy.liteBlocking() : strategy, false, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> create(ExecutorService executor, ExecutorService requestTaskExecutor, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new WorkQueueProcessor<E>(null, executor, requestTaskExecutor, bufferSize, strategy == null ? WaitStrategy.liteBlocking() : strategy, false, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> share(boolean autoCancel) {
        return WorkQueueProcessor.share(WorkQueueProcessor.class.getSimpleName(), QueueSupplier.SMALL_BUFFER_SIZE, null, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> share(ExecutorService service) {
        return WorkQueueProcessor.share(service, QueueSupplier.SMALL_BUFFER_SIZE, null, true);
    }

    public static <E> WorkQueueProcessor<E> share(ExecutorService service, boolean autoCancel) {
        return WorkQueueProcessor.share(service, QueueSupplier.SMALL_BUFFER_SIZE, null, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> share(String name, int bufferSize) {
        return WorkQueueProcessor.share(name, bufferSize, null, true);
    }

    public static <E> WorkQueueProcessor<E> share(String name, int bufferSize, boolean autoCancel) {
        return WorkQueueProcessor.share(name, bufferSize, null, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> share(ExecutorService service, int bufferSize) {
        return WorkQueueProcessor.share(service, bufferSize, null, true);
    }

    public static <E> WorkQueueProcessor<E> share(ExecutorService service, int bufferSize, boolean autoCancel) {
        return WorkQueueProcessor.share(service, bufferSize, null, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> share(String name, int bufferSize, WaitStrategy strategy) {
        return WorkQueueProcessor.share(name, bufferSize, strategy, true);
    }

    public static <E> WorkQueueProcessor<E> share(String name, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new WorkQueueProcessor<E>(name, bufferSize, strategy == null ? WaitStrategy.liteBlocking() : strategy, true, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> share(ExecutorService executor, int bufferSize, WaitStrategy strategy) {
        return WorkQueueProcessor.share(executor, bufferSize, strategy, true);
    }

    public static <E> WorkQueueProcessor<E> share(ExecutorService executor, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new WorkQueueProcessor<E>(null, executor, bufferSize, strategy == null ? WaitStrategy.liteBlocking() : strategy, true, autoCancel);
    }

    public static <E> WorkQueueProcessor<E> share(ExecutorService executor, ExecutorService requestTaskExecutor, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new WorkQueueProcessor<E>(null, executor, requestTaskExecutor, bufferSize, strategy == null ? WaitStrategy.liteBlocking() : strategy, true, autoCancel);
    }

    WorkQueueProcessor(String name, int bufferSize, WaitStrategy waitStrategy, boolean share, boolean autoCancel) {
        this(new EventLoopProcessor.EventLoopFactory(name, autoCancel), null, bufferSize, waitStrategy, share, autoCancel);
    }

    WorkQueueProcessor(ThreadFactory threadFactory, ExecutorService executor, int bufferSize, WaitStrategy waitStrategy, boolean share, boolean autoCancel) {
        this(threadFactory, executor, WorkQueueProcessor.defaultRequestTaskExecutor(WorkQueueProcessor.defaultName(threadFactory, WorkQueueProcessor.class)), bufferSize, waitStrategy, share, autoCancel);
    }

    WorkQueueProcessor(ThreadFactory threadFactory, ExecutorService executor, ExecutorService requestTaskExecutor, int bufferSize, WaitStrategy waitStrategy, boolean share, boolean autoCancel) {
        super(bufferSize, threadFactory, executor, autoCancel, share, FACTORY, waitStrategy);
        Objects.requireNonNull(requestTaskExecutor, "requestTaskExecutor");
        this.writeWait = waitStrategy;
        this.ringBuffer.addGatingSequence(this.workSequence);
        this.requestTaskExecutor = requestTaskExecutor;
    }

    @Override
    public void subscribe(Subscriber<? super E> subscriber) {
        if (subscriber == null) {
            throw Exceptions.argumentIsNullException();
        }
        if (!this.alive()) {
            TopicProcessor.coldSource(this.ringBuffer, null, this.error, this.workSequence).subscribe(subscriber);
            return;
        }
        WorkQueueInner<? super E> signalProcessor = new WorkQueueInner<E>(subscriber, this);
        try {
            this.incrementSubscribers();
            signalProcessor.sequence.set(this.workSequence.getAsLong());
            this.ringBuffer.addGatingSequence(signalProcessor.sequence);
            int maxSubscribers = WorkQueueProcessor.bestEffortMaxSubscribers(this.executor);
            if (maxSubscribers > Integer.MIN_VALUE && this.subscriberCount > maxSubscribers) {
                throw new IllegalStateException("The executor service could not accommodate another subscriber, detected limit " + maxSubscribers);
            }
            this.executor.execute(signalProcessor);
        }
        catch (Throwable t) {
            this.decrementSubscribers();
            this.ringBuffer.removeGatingSequence(signalProcessor.sequence);
            if (RejectedExecutionException.class.isAssignableFrom(t.getClass())) {
                TopicProcessor.coldSource(this.ringBuffer, t, this.error, this.workSequence).subscribe(subscriber);
            }
            Operators.error(subscriber, t);
        }
    }

    static int bestEffortMaxSubscribers(ExecutorService executor) {
        int maxSubscribers = Integer.MIN_VALUE;
        if (executor instanceof ThreadPoolExecutor) {
            maxSubscribers = ((ThreadPoolExecutor)executor).getMaximumPoolSize();
        } else if (executor instanceof ForkJoinPool) {
            maxSubscribers = ((ForkJoinPool)executor).getParallelism();
        }
        return maxSubscribers;
    }

    @Override
    public Flux<E> drain() {
        return TopicProcessor.coldSource(this.ringBuffer, null, this.error, this.workSequence);
    }

    @Override
    protected void doError(Throwable t) {
        this.writeWait.signalAllWhenBlocking();
    }

    @Override
    protected void doComplete() {
        this.writeWait.signalAllWhenBlocking();
    }

    @Override
    protected void requestTask(Subscription s) {
        this.requestTaskExecutor.execute(EventLoopProcessor.createRequestTask(s, () -> {
            if (!this.alive()) {
                WaitStrategy.alert();
            }
        }, null, this.ringBuffer::getMinimumGatingSequence, this.readWait, this, this.ringBuffer.bufferSize()));
    }

    @Override
    public long getPending() {
        return this.getBufferSize() - this.ringBuffer.getPending() + this.claimedDisposed.size();
    }

    @Override
    public void run() {
        if (!this.alive()) {
            WaitStrategy.alert();
        }
    }

    @Override
    protected void specificShutdown() {
        this.requestTaskExecutor.shutdown();
    }

    static final class WorkQueueInner<T>
    implements Runnable,
    InnerProducer<T> {
        final AtomicBoolean running = new AtomicBoolean(true);
        final RingBuffer.Sequence sequence = RingBuffer.newSequence(-1L);
        final RingBuffer.Sequence pendingRequest = RingBuffer.newSequence(0L);
        final RingBuffer.Reader barrier;
        final WorkQueueProcessor<T> processor;
        final Subscriber<? super T> subscriber;
        final Runnable waiter = new Runnable(){

            @Override
            public void run() {
                if (barrier.isAlerted() || !this.isRunning() || this.replay(pendingRequest.getAsLong() == Long.MAX_VALUE)) {
                    WaitStrategy.alert();
                }
            }
        };

        WorkQueueInner(Subscriber<? super T> subscriber, WorkQueueProcessor<T> processor) {
            this.processor = processor;
            this.subscriber = subscriber;
            this.barrier = processor.ringBuffer.newReader();
        }

        void halt() {
            this.running.set(false);
            this.barrier.alert();
        }

        boolean isRunning() {
            return this.running.get() && (this.processor.terminated == 0 || this.processor.error == null && this.processor.ringBuffer.getAsLong() > this.sequence.getAsLong());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block34: {
                processedSequence = true;
                try {
                    Thread.currentThread().setContextClassLoader(this.processor.contextClassLoader);
                    this.subscriber.onSubscribe((Subscription)this);
                    cachedAvailableSequence = -9223372036854775808L;
                    nextSequence = this.sequence.getAsLong();
                    event = null;
                    if (!EventLoopProcessor.waitRequestOrTerminalEvent(this.pendingRequest, this.barrier, this.running, this.sequence, this.waiter)) {
                        if (!this.running.get()) {
                            return;
                        }
                        if (this.processor.terminated == 1 && this.processor.ringBuffer.getAsLong() == -1L) {
                            if (this.processor.error != null) {
                                this.subscriber.onError(this.processor.error);
                                return;
                            }
                            this.subscriber.onComplete();
                            return;
                        }
                    }
                    v0 = unbounded = this.pendingRequest.getAsLong() == 0x7FFFFFFFFFFFFFFFL;
                    if (this.replay(unbounded)) {
                        this.running.set(false);
                        return;
                    }
                    while (true) {
                        try {
                            while (true) {
                                if (processedSequence) {
                                    if (!this.running.get()) {
                                        break block34;
                                    }
                                    processedSequence = false;
                                    do {
                                        nextSequence = this.processor.workSequence.getAsLong() + 1L;
                                        while (!unbounded && this.pendingRequest.getAsLong() == 0L) {
                                            if (!this.isRunning()) {
                                                WaitStrategy.alert();
                                            }
                                            LockSupport.parkNanos(1L);
                                        }
                                        this.sequence.set(nextSequence - 1L);
                                    } while (!this.processor.workSequence.compareAndSet(nextSequence - 1L, nextSequence));
                                }
                                if (cachedAvailableSequence >= nextSequence) {
                                    event = (EventLoopProcessor.Slot)this.processor.ringBuffer.get(nextSequence);
                                    try {
                                        this.readNextEvent(unbounded);
                                    }
                                    catch (Exception ce) {
                                        if (!this.running.get() || !WaitStrategy.isAlert(ce)) {
                                            throw ce;
                                        }
                                        this.barrier.clearAlert();
                                    }
                                    processedSequence = true;
                                    this.subscriber.onNext(event.value);
                                    continue;
                                }
                                this.processor.readWait.signalAllWhenBlocking();
                                cachedAvailableSequence = this.barrier.waitFor(nextSequence, this.waiter);
                            }
                        }
                        catch (InterruptedException | RuntimeException ce) {
                            if (Exceptions.isCancel(ce)) {
                                this.reschedule(event);
                            } else {
                                if (!WaitStrategy.isAlert(ce)) {
                                    throw Exceptions.propagate(ce);
                                }
                                this.barrier.clearAlert();
                                if (!this.running.get()) {
                                } else {
                                    if (this.processor.terminated != 1) continue;
                                    if (this.processor.error != null) {
                                        processedSequence = true;
                                        this.subscriber.onError(this.processor.error);
                                    } else {
                                        if (this.processor.ringBuffer.getPending() == 0) ** break;
                                        continue;
                                        processedSequence = true;
                                        this.subscriber.onComplete();
                                    }
                                }
                            }
                        }
                        break;
                    }
                }
                finally {
                    this.processor.decrementSubscribers();
                    this.running.set(false);
                    if (!processedSequence) {
                        this.processor.claimedDisposed.add(this.sequence);
                    } else {
                        this.processor.ringBuffer.removeGatingSequence(this.sequence);
                    }
                    this.processor.writeWait.signalAllWhenBlocking();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        boolean replay(boolean unbounded) {
            block16: {
                if (!WorkQueueProcessor.REPLAYING.compareAndSet(this.processor, 0, 1)) break block16;
                try {
                    s = null;
                    while (true) {
                        if (!this.running.get()) {
                            this.processor.readWait.signalAllWhenBlocking();
                            var3_6 = true;
                            return var3_6;
                        }
                        v = this.processor.claimedDisposed.peek();
                        if (v == null) {
                            this.processor.readWait.signalAllWhenBlocking();
                            var4_10 = this.processor.alive() == false && this.processor.ringBuffer.getPending() == 0;
                            return var4_10;
                        }
                        if (!(v instanceof RingBuffer.Sequence)) ** GOTO lbl32
                        s = (RingBuffer.Sequence)v;
                        cursor = s.getAsLong() + 1L;
                        if (cursor > this.processor.ringBuffer.getAsLong()) {
                            this.processor.readWait.signalAllWhenBlocking();
                            var6_11 = this.processor.alive() == false && this.processor.ringBuffer.getPending() == 0;
                            return var6_11;
                        }
                        this.barrier.waitFor(cursor, this.waiter);
                        v = ((EventLoopProcessor.Slot)this.processor.ringBuffer.get((long)cursor)).value;
                        if (v == null) {
                            this.processor.ringBuffer.removeGatingSequence(s);
                            this.processor.claimedDisposed.poll();
                            s = null;
                            continue;
                        }
lbl32:
                        // 3 sources

                        this.readNextEvent(unbounded);
                        this.subscriber.onNext(v);
                        this.processor.claimedDisposed.poll();
                        if (s == null) continue;
                        this.processor.ringBuffer.removeGatingSequence(s);
                        s = null;
                        continue;
                        break;
                    }
                    catch (RuntimeException ce) {
                        if (!this.running.get() || Exceptions.isCancel(ce)) {
                            this.running.set(false);
                            var3_7 = true;
                            return var3_7;
                        }
                        throw ce;
                    }
                    catch (InterruptedException e) {
                        this.running.set(false);
                        var3_8 = true;
                        return var3_8;
                    }
                }
                finally {
                    WorkQueueProcessor.REPLAYING.compareAndSet(this.processor, 1, 0);
                }
            }
            return this.processor.alive() == false && this.processor.ringBuffer.getPending() == 0;
        }

        boolean reschedule(EventLoopProcessor.Slot<T> event) {
            if (event != null && event.value != null) {
                this.processor.claimedDisposed.add(event.value);
                this.barrier.alert();
                this.processor.readWait.signalAllWhenBlocking();
                return true;
            }
            return false;
        }

        void readNextEvent(boolean unbounded) {
            while (!unbounded && EventLoopProcessor.getAndSub(this.pendingRequest, 1L) == 0L) {
                if (!this.isRunning()) {
                    WaitStrategy.alert();
                }
                LockSupport.parkNanos(1L);
            }
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.processor;
                }
                case PREFETCH: {
                    return Integer.MAX_VALUE;
                }
                case TERMINATED: {
                    return this.processor.isTerminated();
                }
                case CANCELLED: {
                    return !this.running.get();
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.pendingRequest.getAsLong();
                }
            }
            return InnerProducer.super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.subscriber;
        }

        public void request(long n) {
            if (Operators.checkRequest(n, this.subscriber)) {
                if (!this.running.get()) {
                    return;
                }
                EventLoopProcessor.addCap(this.pendingRequest, n);
            }
        }

        public void cancel() {
            this.halt();
        }
    }
}

