/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import reactor.core.Cancellation;
import reactor.core.Disposable;
import reactor.core.scheduler.ExecutorServiceScheduler;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.concurrent.OpenHashSet;

final class ParallelScheduler
implements Scheduler,
Supplier<ScheduledExecutorService> {
    static final AtomicLong COUNTER = new AtomicLong();
    final int n;
    final ThreadFactory factory;
    volatile ScheduledExecutorService[] executors;
    static final AtomicReferenceFieldUpdater<ParallelScheduler, ScheduledExecutorService[]> EXECUTORS = AtomicReferenceFieldUpdater.newUpdater(ParallelScheduler.class, ScheduledExecutorService[].class, "executors");
    static final ScheduledExecutorService[] SHUTDOWN = new ScheduledExecutorService[0];
    static final ScheduledExecutorService TERMINATED = Executors.newSingleThreadScheduledExecutor();
    int roundRobin;

    ParallelScheduler(int n, ThreadFactory factory) {
        if (n <= 0) {
            throw new IllegalArgumentException("n > 0 required but it was " + n);
        }
        this.n = n;
        this.factory = factory;
        this.init(n);
    }

    @Override
    public ScheduledExecutorService get() {
        return Executors.newSingleThreadScheduledExecutor(this.factory);
    }

    void init(int n) {
        ScheduledExecutorService[] a = new ScheduledExecutorService[n];
        for (int i = 0; i < n; ++i) {
            a[i] = Schedulers.decorateScheduledExecutorService("parallel", this);
        }
        EXECUTORS.lazySet(this, a);
    }

    @Override
    public boolean isDisposed() {
        return this.executors == SHUTDOWN;
    }

    @Override
    public void start() {
        ScheduledExecutorService[] a;
        ScheduledExecutorService[] b = null;
        do {
            if ((a = this.executors) != SHUTDOWN) {
                if (b != null) {
                    for (ScheduledExecutorService exec : b) {
                        exec.shutdownNow();
                    }
                }
                return;
            }
            if (b != null) continue;
            b = new ScheduledExecutorService[this.n];
            for (int i = 0; i < this.n; ++i) {
                b[i] = Schedulers.decorateScheduledExecutorService("parallel", this);
            }
        } while (!EXECUTORS.compareAndSet(this, a, b));
    }

    @Override
    public void shutdown() {
        this.dispose();
    }

    @Override
    public void dispose() {
        ScheduledExecutorService[] a = this.executors;
        if (a != SHUTDOWN && (a = EXECUTORS.getAndSet(this, SHUTDOWN)) != SHUTDOWN) {
            for (ScheduledExecutorService exec : a) {
                Schedulers.executorServiceShutdown(exec, "parallel");
            }
        }
    }

    ScheduledExecutorService pick() {
        ScheduledExecutorService[] a = this.executors;
        if (a != SHUTDOWN) {
            int idx = this.roundRobin;
            if (idx == this.n) {
                idx = 0;
                this.roundRobin = 0;
            } else {
                this.roundRobin = idx + 1;
            }
            return a[idx];
        }
        return TERMINATED;
    }

    @Override
    public Disposable schedule(Runnable task) {
        ScheduledExecutorService exec = this.pick();
        try {
            return new ExecutorServiceScheduler.DisposableFuture(exec.submit(task), false);
        }
        catch (RejectedExecutionException ex) {
            return REJECTED;
        }
    }

    @Override
    public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        ScheduledExecutorService exec = this.pick();
        try {
            return new ExecutorServiceScheduler.DisposableFuture(exec.schedule(task, delay, unit), false);
        }
        catch (RejectedExecutionException ex) {
            return REJECTED;
        }
    }

    @Override
    public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        ScheduledExecutorService exec = this.pick();
        try {
            return new ExecutorServiceScheduler.DisposableFuture(exec.scheduleAtFixedRate(task, initialDelay, period, unit), false);
        }
        catch (RejectedExecutionException ex) {
            return REJECTED;
        }
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new ParallelWorker(this.pick());
    }

    static {
        TERMINATED.shutdownNow();
    }

    static final class ParallelWorker
    implements Scheduler.Worker {
        final ScheduledExecutorService exec;
        OpenHashSet<ParallelWorkerTask> tasks;
        volatile boolean shutdown;

        public ParallelWorker(ScheduledExecutorService exec) {
            this.exec = exec;
            this.tasks = new OpenHashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Disposable schedule(Runnable task) {
            Future<?> f;
            if (this.shutdown) {
                return Scheduler.REJECTED;
            }
            ParallelWorkerTask pw = new ParallelWorkerTask(task, this);
            ParallelWorker parallelWorker = this;
            synchronized (parallelWorker) {
                if (this.shutdown) {
                    return Scheduler.REJECTED;
                }
                this.tasks.add(pw);
            }
            try {
                f = this.exec.submit(pw);
            }
            catch (RejectedExecutionException ex) {
                return Scheduler.REJECTED;
            }
            if (this.shutdown) {
                f.cancel(true);
                return pw;
            }
            pw.setFuture(f);
            return pw;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Cancellation schedule(Runnable task, long delay, TimeUnit unit) {
            ScheduledFuture<?> f;
            if (this.shutdown) {
                return Scheduler.REJECTED;
            }
            ParallelWorkerTask pw = new ParallelWorkerTask(task, this);
            ParallelWorker parallelWorker = this;
            synchronized (parallelWorker) {
                if (this.shutdown) {
                    return Scheduler.REJECTED;
                }
                this.tasks.add(pw);
            }
            try {
                f = this.exec.schedule(pw, delay, unit);
            }
            catch (RejectedExecutionException ex) {
                return Scheduler.REJECTED;
            }
            if (this.shutdown) {
                f.cancel(true);
                return pw;
            }
            pw.setFuture(f);
            return pw;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Cancellation schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            ScheduledFuture<?> f;
            if (this.shutdown) {
                return Scheduler.REJECTED;
            }
            ParallelWorkerTask pw = new ParallelWorkerTask(task, this);
            ParallelWorker parallelWorker = this;
            synchronized (parallelWorker) {
                if (this.shutdown) {
                    return Scheduler.REJECTED;
                }
                this.tasks.add(pw);
            }
            try {
                f = this.exec.scheduleAtFixedRate(pw, initialDelay, period, unit);
            }
            catch (RejectedExecutionException ex) {
                return Scheduler.REJECTED;
            }
            if (this.shutdown) {
                f.cancel(true);
                return pw;
            }
            pw.setFuture(f);
            return pw;
        }

        @Override
        public void shutdown() {
            this.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            OpenHashSet<ParallelWorkerTask> set;
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            ParallelWorker parallelWorker = this;
            synchronized (parallelWorker) {
                set = this.tasks;
                this.tasks = null;
            }
            if (set != null) {
                Object[] a;
                for (Object o : a = set.keys()) {
                    if (o == null) continue;
                    ((ParallelWorkerTask)o).cancelFuture();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.shutdown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(ParallelWorkerTask task) {
            if (this.shutdown) {
                return;
            }
            ParallelWorker parallelWorker = this;
            synchronized (parallelWorker) {
                if (this.shutdown) {
                    return;
                }
                this.tasks.remove(task);
            }
        }

        static final class ParallelWorkerTask
        implements Runnable,
        Disposable {
            final Runnable run;
            final ParallelWorker parent;
            volatile boolean cancelled;
            volatile Future<?> future;
            static final AtomicReferenceFieldUpdater<ParallelWorkerTask, Future> FUTURE = AtomicReferenceFieldUpdater.newUpdater(ParallelWorkerTask.class, Future.class, "future");
            static final Future<Object> FINISHED = CompletableFuture.completedFuture(null);
            static final Future<Object> CANCELLED = CompletableFuture.completedFuture(null);

            public ParallelWorkerTask(Runnable run, ParallelWorker parent) {
                this.run = run;
                this.parent = parent;
            }

            @Override
            public void run() {
                if (this.cancelled || this.parent.shutdown) {
                    return;
                }
                try {
                    try {
                        this.run.run();
                    }
                    catch (Throwable ex) {
                        Schedulers.handleError(ex);
                    }
                }
                finally {
                    Future<?> f;
                    while ((f = this.future) != CANCELLED) {
                        if (!FUTURE.compareAndSet(this, f, FINISHED)) continue;
                        this.parent.remove(this);
                        break;
                    }
                }
            }

            @Override
            public boolean isDisposed() {
                Future<?> a = this.future;
                return FINISHED == a || CANCELLED == a;
            }

            @Override
            public void dispose() {
                if (!this.cancelled) {
                    this.cancelled = true;
                    Future<Object> f = this.future;
                    if (f != CANCELLED && f != FINISHED && (f = FUTURE.getAndSet(this, CANCELLED)) != CANCELLED && f != FINISHED) {
                        if (f != null) {
                            f.cancel(this.parent.shutdown);
                        }
                        this.parent.remove(this);
                    }
                }
            }

            void setFuture(Future<?> f) {
                if (!(this.future == null && FUTURE.compareAndSet(this, null, f) || this.future == FINISHED)) {
                    f.cancel(this.parent.shutdown);
                }
            }

            void cancelFuture() {
                Future<Object> f = this.future;
                if (f != CANCELLED && f != FINISHED && (f = FUTURE.getAndSet(this, CANCELLED)) != null && f != CANCELLED && f != FINISHED) {
                    f.cancel(true);
                }
            }
        }
    }
}

