/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;

final class FluxSkipUntilOther<T, U>
extends FluxSource<T, T> {
    final Publisher<U> other;

    FluxSkipUntilOther(Flux<? extends T> source, Publisher<U> other) {
        super(source);
        this.other = Objects.requireNonNull(other, "other");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        SkipUntilMainSubscriber<? super T> mainSubscriber = new SkipUntilMainSubscriber<T>(s);
        SkipUntilOtherSubscriber otherSubscriber = new SkipUntilOtherSubscriber(mainSubscriber);
        this.other.subscribe(otherSubscriber);
        this.source.subscribe(mainSubscriber);
    }

    static final class SkipUntilMainSubscriber<T>
    implements InnerOperator<T, T> {
        final Subscriber<? super T> actual;
        volatile Subscription main;
        static final AtomicReferenceFieldUpdater<SkipUntilMainSubscriber, Subscription> MAIN = AtomicReferenceFieldUpdater.newUpdater(SkipUntilMainSubscriber.class, Subscription.class, "main");
        volatile Subscription other;
        static final AtomicReferenceFieldUpdater<SkipUntilMainSubscriber, Subscription> OTHER = AtomicReferenceFieldUpdater.newUpdater(SkipUntilMainSubscriber.class, Subscription.class, "other");
        volatile boolean gate;

        @Override
        public final Subscriber<? super T> actual() {
            return this.actual;
        }

        SkipUntilMainSubscriber(Subscriber<? super T> actual) {
            this.actual = Operators.serialize(actual);
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.main;
                }
                case CANCELLED: {
                    return this.main == Operators.cancelledSubscription();
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(Scannable.from(this.other));
        }

        void setOther(Subscription s) {
            if (!OTHER.compareAndSet(this, null, s)) {
                s.cancel();
                if (this.other != Operators.cancelledSubscription()) {
                    Operators.reportSubscriptionSet();
                }
            }
        }

        public void request(long n) {
            this.main.request(n);
        }

        public void cancel() {
            Operators.terminate(MAIN, this);
            Operators.terminate(OTHER, this);
        }

        public void onSubscribe(Subscription s) {
            if (!MAIN.compareAndSet(this, null, s)) {
                s.cancel();
                if (this.main != Operators.cancelledSubscription()) {
                    Operators.reportSubscriptionSet();
                }
            } else {
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.gate) {
                this.actual.onNext(t);
            } else {
                this.main.request(1L);
            }
        }

        public void onError(Throwable t) {
            if (MAIN.compareAndSet(this, null, Operators.cancelledSubscription())) {
                Operators.error(this.actual, t);
                return;
            }
            if (this.main == Operators.cancelledSubscription()) {
                Operators.onErrorDropped(t);
                return;
            }
            this.cancel();
            this.actual.onError(t);
        }

        public void onComplete() {
            Operators.terminate(OTHER, this);
            this.actual.onComplete();
        }
    }

    static final class SkipUntilOtherSubscriber<U>
    implements InnerConsumer<U> {
        final SkipUntilMainSubscriber<?> main;

        SkipUntilOtherSubscriber(SkipUntilMainSubscriber<?> main) {
            this.main = main;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case CANCELLED: {
                    return this.main.other == Operators.cancelledSubscription();
                }
                case PARENT: {
                    return this.main.other;
                }
                case ACTUAL: {
                    return this.main;
                }
            }
            return null;
        }

        public void onSubscribe(Subscription s) {
            this.main.setOther(s);
            s.request(Long.MAX_VALUE);
        }

        public void onNext(U t) {
            if (this.main.gate) {
                return;
            }
            SkipUntilMainSubscriber<?> m = this.main;
            m.other.cancel();
            m.gate = true;
            m.other = Operators.cancelledSubscription();
        }

        public void onError(Throwable t) {
            SkipUntilMainSubscriber<?> m = this.main;
            if (m.gate) {
                Operators.onErrorDropped(t);
                return;
            }
            m.onError(t);
        }

        public void onComplete() {
            SkipUntilMainSubscriber<?> m = this.main;
            if (m.gate) {
                return;
            }
            m.gate = true;
            m.other = Operators.cancelledSubscription();
        }
    }
}

