/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoCount<T>
extends MonoSource<T, Long>
implements Fuseable {
    MonoCount(Flux<? extends T> source) {
        super(source);
    }

    @Override
    public void subscribe(Subscriber<? super Long> s) {
        this.source.subscribe(new CountSubscriber((Subscriber<? super Long>)((Subscriber<Long>)s)));
    }

    static final class CountSubscriber<T>
    extends Operators.MonoSubscriber<T, Long> {
        long counter;
        Subscription s;

        CountSubscriber(Subscriber<? super Long> actual) {
            super(actual);
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
            }
            return super.scan(key);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            ++this.counter;
        }

        @Override
        public void onComplete() {
            this.complete(this.counter);
        }
    }
}

