/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Operators;

final class FluxIterable<T>
extends Flux<T>
implements Fuseable {
    final Iterable<? extends T> iterable;

    FluxIterable(Iterable<? extends T> iterable) {
        this.iterable = Objects.requireNonNull(iterable, "iterable");
    }

    public void subscribe(Subscriber<? super T> s) {
        Iterator<? extends T> it;
        try {
            it = this.iterable.iterator();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        FluxIterable.subscribe(s, it);
    }

    static <T> void subscribe(Subscriber<? super T> s, Iterator<? extends T> it) {
        boolean b;
        if (it == null) {
            Operators.error(s, new NullPointerException("The iterator is null"));
            return;
        }
        try {
            b = it.hasNext();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (!b) {
            Operators.complete(s);
            return;
        }
        if (s instanceof Fuseable.ConditionalSubscriber) {
            s.onSubscribe(new IterableSubscriptionConditional<T>((Fuseable.ConditionalSubscriber)s, it));
        } else {
            s.onSubscribe(new IterableSubscription<T>(s, it));
        }
    }

    static final class IterableSubscriptionConditional<T>
    implements InnerProducer<T>,
    Fuseable.SynchronousSubscription<T> {
        final Fuseable.ConditionalSubscriber<? super T> actual;
        final Iterator<? extends T> iterator;
        volatile boolean cancelled;
        volatile long requested;
        static final AtomicLongFieldUpdater<IterableSubscriptionConditional> REQUESTED = AtomicLongFieldUpdater.newUpdater(IterableSubscriptionConditional.class, "requested");
        int state;
        static final int STATE_HAS_NEXT_NO_VALUE = 0;
        static final int STATE_HAS_NEXT_HAS_VALUE = 1;
        static final int STATE_NO_NEXT = 2;
        static final int STATE_CALL_HAS_NEXT = 3;
        T current;

        IterableSubscriptionConditional(Fuseable.ConditionalSubscriber<? super T> actual, Iterator<? extends T> iterator) {
            this.actual = actual;
            this.iterator = iterator;
        }

        public void request(long n) {
            if (Operators.validate(n) && Operators.getAndAddCap(REQUESTED, this, n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastPath();
                } else {
                    this.slowPath(n);
                }
            }
        }

        void slowPath(long n) {
            Iterator<T> a = this.iterator;
            Fuseable.ConditionalSubscriber<? super T> s = this.actual;
            long e = 0L;
            while (true) {
                if (e != n) {
                    boolean b;
                    T t;
                    try {
                        t = Objects.requireNonNull(a.next(), "The iterator returned a null value");
                    }
                    catch (Throwable ex) {
                        s.onError(ex);
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    boolean consumed = s.tryOnNext((T)t);
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        b = a.hasNext();
                    }
                    catch (Throwable ex) {
                        s.onError(ex);
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (!b) {
                        s.onComplete();
                        return;
                    }
                    if (!consumed) continue;
                    ++e;
                    continue;
                }
                n = this.requested;
                if (n != e) continue;
                n = REQUESTED.addAndGet(this, -e);
                if (n == 0L) {
                    return;
                }
                e = 0L;
            }
        }

        void fastPath() {
            boolean b;
            Iterator<T> a = this.iterator;
            Fuseable.ConditionalSubscriber<? super T> s = this.actual;
            do {
                T t;
                if (this.cancelled) {
                    return;
                }
                try {
                    t = Objects.requireNonNull(a.next(), "The iterator returned a null value");
                }
                catch (Exception ex) {
                    s.onError(ex);
                    return;
                }
                if (this.cancelled) {
                    return;
                }
                s.tryOnNext((T)t);
                if (this.cancelled) {
                    return;
                }
                try {
                    b = a.hasNext();
                }
                catch (Exception ex) {
                    s.onError(ex);
                    return;
                }
                if (!this.cancelled) continue;
                return;
            } while (b);
            s.onComplete();
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case CANCELLED: {
                    return this.cancelled;
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
                case TERMINATED: {
                    return this.state == 2;
                }
            }
            return InnerProducer.super.scan(key);
        }

        @Override
        public void clear() {
            this.state = 2;
        }

        @Override
        public boolean isEmpty() {
            int s = this.state;
            if (s == 2) {
                return true;
            }
            if (s == 1 || s == 0) {
                return false;
            }
            if (this.iterator.hasNext()) {
                this.state = 0;
                return false;
            }
            this.state = 2;
            return true;
        }

        @Override
        public T poll() {
            if (!this.isEmpty()) {
                T c;
                if (this.state == 0) {
                    c = this.iterator.next();
                } else {
                    c = this.current;
                    this.current = null;
                }
                this.state = 3;
                return c;
            }
            return null;
        }

        @Override
        public int size() {
            if (this.state == 2) {
                return 0;
            }
            return 1;
        }
    }

    static final class IterableSubscription<T>
    implements InnerProducer<T>,
    Fuseable.SynchronousSubscription<T> {
        final Subscriber<? super T> actual;
        final Iterator<? extends T> iterator;
        volatile boolean cancelled;
        volatile long requested;
        static final AtomicLongFieldUpdater<IterableSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(IterableSubscription.class, "requested");
        int state;
        static final int STATE_HAS_NEXT_NO_VALUE = 0;
        static final int STATE_HAS_NEXT_HAS_VALUE = 1;
        static final int STATE_NO_NEXT = 2;
        static final int STATE_CALL_HAS_NEXT = 3;
        T current;

        IterableSubscription(Subscriber<? super T> actual, Iterator<? extends T> iterator) {
            this.actual = actual;
            this.iterator = iterator;
        }

        public void request(long n) {
            if (Operators.validate(n) && Operators.getAndAddCap(REQUESTED, this, n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastPath();
                } else {
                    this.slowPath(n);
                }
            }
        }

        void slowPath(long n) {
            Iterator<T> a = this.iterator;
            Subscriber<? super T> s = this.actual;
            long e = 0L;
            while (true) {
                if (e != n) {
                    boolean b;
                    T t;
                    try {
                        t = Objects.requireNonNull(a.next(), "The iterator returned a null value");
                    }
                    catch (Throwable ex) {
                        s.onError(ex);
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    s.onNext(t);
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        b = a.hasNext();
                    }
                    catch (Throwable ex) {
                        s.onError(ex);
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (!b) {
                        s.onComplete();
                        return;
                    }
                    ++e;
                    continue;
                }
                n = this.requested;
                if (n != e) continue;
                n = REQUESTED.addAndGet(this, -e);
                if (n == 0L) {
                    return;
                }
                e = 0L;
            }
        }

        void fastPath() {
            boolean b;
            Iterator<T> a = this.iterator;
            Subscriber<? super T> s = this.actual;
            do {
                T t;
                if (this.cancelled) {
                    return;
                }
                try {
                    t = Objects.requireNonNull(a.next(), "The iterator returned a null value");
                }
                catch (Exception ex) {
                    s.onError((Throwable)ex);
                    return;
                }
                if (this.cancelled) {
                    return;
                }
                s.onNext(t);
                if (this.cancelled) {
                    return;
                }
                try {
                    b = a.hasNext();
                }
                catch (Exception ex) {
                    s.onError((Throwable)ex);
                    return;
                }
                if (!this.cancelled) continue;
                return;
            } while (b);
            s.onComplete();
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case CANCELLED: {
                    return this.cancelled;
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
                case TERMINATED: {
                    return this.state == 2;
                }
            }
            return InnerProducer.super.scan(key);
        }

        @Override
        public void clear() {
            this.state = 2;
        }

        @Override
        public boolean isEmpty() {
            int s = this.state;
            if (s == 2) {
                return true;
            }
            if (s == 1 || s == 0) {
                return false;
            }
            if (this.iterator.hasNext()) {
                this.state = 0;
                return false;
            }
            this.state = 2;
            return true;
        }

        @Override
        public T poll() {
            if (!this.isEmpty()) {
                T c;
                if (this.state == 0) {
                    c = this.iterator.next();
                } else {
                    c = this.current;
                    this.current = null;
                }
                this.state = 3;
                if (c == null) {
                    throw new NullPointerException("The iterator returned a null value");
                }
                return c;
            }
            return null;
        }

        @Override
        public int size() {
            if (this.state == 2) {
                return 0;
            }
            return 1;
        }
    }
}

