/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.FluxConcatMap;
import reactor.core.publisher.FluxFlatMap;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Operators;
import reactor.util.concurrent.QueueSupplier;

final class FluxMergeSequential<T, R>
extends FluxSource<T, R> {
    final FluxConcatMap.ErrorMode errorMode;
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final int maxConcurrency;
    final int prefetch;
    final Supplier<Queue<MergeSequentialInner<R>>> queueSupplier;

    FluxMergeSequential(Publisher<? extends T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int prefetch, FluxConcatMap.ErrorMode errorMode) {
        this(source, mapper, maxConcurrency, prefetch, errorMode, QueueSupplier.get(Math.max(prefetch, maxConcurrency)));
    }

    FluxMergeSequential(Publisher<? extends T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int prefetch, FluxConcatMap.ErrorMode errorMode, Supplier<Queue<MergeSequentialInner<R>>> queueSupplier) {
        super(source);
        if (prefetch <= 0) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + prefetch);
        }
        if (maxConcurrency <= 0) {
            throw new IllegalArgumentException("maxConcurrency > 0 required but it was " + maxConcurrency);
        }
        this.mapper = Objects.requireNonNull(mapper, "mapper");
        this.maxConcurrency = maxConcurrency;
        this.prefetch = prefetch;
        this.errorMode = errorMode;
        this.queueSupplier = queueSupplier;
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        if (FluxFlatMap.trySubscribeScalarMap(this.source, s, this.mapper, false)) {
            return;
        }
        MergeSequentialMain<? super T, ? super R> parent = new MergeSequentialMain<T, R>(s, this.mapper, this.maxConcurrency, this.prefetch, this.errorMode, this.queueSupplier);
        this.source.subscribe(parent);
    }

    static final class MergeSequentialInner<R>
    implements InnerConsumer<R> {
        final MergeSequentialMain<?, R> parent;
        final int prefetch;
        final int limit;
        volatile Queue<R> queue;
        volatile Subscription subscription;
        static final AtomicReferenceFieldUpdater<MergeSequentialInner, Subscription> SUBSCRIPTION = AtomicReferenceFieldUpdater.newUpdater(MergeSequentialInner.class, Subscription.class, "subscription");
        volatile boolean done;
        long produced;
        int fusionMode;

        MergeSequentialInner(MergeSequentialMain<?, R> parent, int prefetch) {
            this.parent = parent;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.subscription;
                }
                case ACTUAL: {
                    return this.parent;
                }
                case TERMINATED: {
                    return this.done && (this.queue == null || this.queue.isEmpty());
                }
                case CANCELLED: {
                    return this.subscription == Operators.cancelledSubscription();
                }
                case BUFFERED: {
                    return this.queue == null ? 0 : this.queue.size();
                }
                case PREFETCH: {
                    return this.prefetch;
                }
            }
            return null;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(SUBSCRIPTION, this, s)) {
                if (s instanceof Fuseable.QueueSubscription) {
                    Fuseable.QueueSubscription qs = (Fuseable.QueueSubscription)s;
                    int m = qs.requestFusion(7);
                    if (m == 1) {
                        this.fusionMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.parent.innerComplete(this);
                        return;
                    }
                    if (m == 2) {
                        this.fusionMode = m;
                        this.queue = qs;
                        s.request(this.prefetch == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)this.prefetch);
                        return;
                    }
                }
                this.queue = QueueSupplier.get(this.prefetch).get();
                s.request(this.prefetch == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)this.prefetch);
            }
        }

        public void onNext(R t) {
            if (this.fusionMode == 0) {
                this.parent.innerNext(this, t);
            } else {
                this.parent.drain();
            }
        }

        public void onError(Throwable t) {
            this.parent.innerError(this, t);
        }

        public void onComplete() {
            this.parent.innerComplete(this);
        }

        void requestOne() {
            if (this.fusionMode != 1) {
                long p = this.produced + 1L;
                if (p == (long)this.limit) {
                    this.produced = 0L;
                    this.subscription.request(p);
                } else {
                    this.produced = p;
                }
            }
        }

        void cancel() {
            Operators.set(SUBSCRIPTION, this, Operators.cancelledSubscription());
        }

        boolean isDone() {
            return this.done;
        }

        void setDone() {
            this.done = true;
        }

        Queue<R> queue() {
            return this.queue;
        }
    }

    static final class MergeSequentialMain<T, R>
    implements InnerOperator<T, R>,
    InnerProducer<R> {
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final int maxConcurrency;
        final int prefetch;
        final Queue<MergeSequentialInner<R>> subscribers;
        final FluxConcatMap.ErrorMode errorMode;
        final Subscriber<? super R> actual;
        Subscription s;
        volatile boolean done;
        volatile boolean cancelled;
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<MergeSequentialMain, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(MergeSequentialMain.class, Throwable.class, "error");
        MergeSequentialInner<R> current;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<MergeSequentialMain> WIP = AtomicIntegerFieldUpdater.newUpdater(MergeSequentialMain.class, "wip");
        volatile long requested;
        static final AtomicLongFieldUpdater<MergeSequentialMain> REQUESTED = AtomicLongFieldUpdater.newUpdater(MergeSequentialMain.class, "requested");

        MergeSequentialMain(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int prefetch, FluxConcatMap.ErrorMode errorMode, Supplier<Queue<MergeSequentialInner<R>>> queueSupplier) {
            this.actual = actual;
            this.mapper = mapper;
            this.maxConcurrency = maxConcurrency;
            this.prefetch = prefetch;
            this.errorMode = errorMode;
            this.subscribers = queueSupplier.get();
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.subscribers.peek());
        }

        @Override
        public final Subscriber<? super R> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case ERROR: {
                    return this.error;
                }
                case TERMINATED: {
                    return this.done && this.subscribers.isEmpty();
                }
                case DELAY_ERROR: {
                    return this.errorMode != FluxConcatMap.ErrorMode.IMMEDIATE;
                }
                case PREFETCH: {
                    return this.maxConcurrency;
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
                case BUFFERED: {
                    return this.subscribers.size();
                }
            }
            return InnerOperator.super.scan(key);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(this.maxConcurrency == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)this.maxConcurrency);
            }
        }

        public void onNext(T t) {
            Publisher<? extends R> publisher;
            try {
                publisher = Objects.requireNonNull(this.mapper.apply(t), "publisher");
            }
            catch (Throwable ex) {
                this.onError(Operators.onOperatorError(this.s, ex, t));
                return;
            }
            MergeSequentialInner inner = new MergeSequentialInner(this, this.prefetch);
            if (this.cancelled) {
                return;
            }
            if (!this.subscribers.offer(inner)) {
                int badSize = this.subscribers.size();
                inner.cancel();
                this.drainAndCancel();
                this.onError(Operators.onOperatorError(this.s, new IllegalStateException("Too many subscribers for fluxMergeSequential on item: " + t + "; subscribers: " + badSize), t));
                return;
            }
            if (this.cancelled) {
                return;
            }
            publisher.subscribe(inner);
            if (this.cancelled) {
                inner.cancel();
                this.drainAndCancel();
            }
        }

        public void onError(Throwable t) {
            if (Exceptions.addThrowable(ERROR, this, t)) {
                this.done = true;
                this.drain();
            } else {
                Operators.onErrorDropped(t);
            }
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.s.cancel();
            this.drainAndCancel();
        }

        void drainAndCancel() {
            if (WIP.getAndIncrement(this) == 0) {
                do {
                    this.cancelAll();
                } while (WIP.decrementAndGet(this) != 0);
            }
        }

        void cancelAll() {
            MergeSequentialInner<R> inner;
            while ((inner = this.subscribers.poll()) != null) {
                inner.cancel();
            }
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.addAndGet(REQUESTED, this, n);
                this.drain();
            }
        }

        void innerNext(MergeSequentialInner<R> inner, R value) {
            if (inner.queue().offer(value)) {
                this.drain();
            } else {
                inner.cancel();
                this.onError(Operators.onOperatorError(null, Exceptions.failWithOverflow("Queue is full?!"), value));
            }
        }

        void innerError(MergeSequentialInner<R> inner, Throwable e) {
            if (Exceptions.addThrowable(ERROR, this, e)) {
                inner.setDone();
                if (this.errorMode != FluxConcatMap.ErrorMode.END) {
                    this.s.cancel();
                }
                this.drain();
            } else {
                Operators.onErrorDropped(e);
            }
        }

        void innerComplete(MergeSequentialInner<R> inner) {
            inner.setDone();
            this.drain();
        }

        void drain() {
            boolean continueNextSource;
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            int missed = 1;
            MergeSequentialInner<R> inner = this.current;
            Subscriber<? super R> a = this.actual;
            FluxConcatMap.ErrorMode em = this.errorMode;
            do {
                Queue<R> q;
                long r = this.requested;
                long e = 0L;
                if (inner == null) {
                    Throwable ex;
                    if (em != FluxConcatMap.ErrorMode.END && (ex = this.error) != null) {
                        this.cancelAll();
                        a.onError(ex);
                        return;
                    }
                    boolean outerDone = this.done;
                    inner = this.subscribers.poll();
                    if (outerDone && inner == null) {
                        Throwable ex2 = this.error;
                        if (ex2 != null) {
                            a.onError(ex2);
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                    if (inner != null) {
                        this.current = inner;
                    }
                }
                continueNextSource = false;
                if (inner != null && (q = inner.queue()) != null) {
                    boolean d;
                    while (e != r) {
                        boolean empty;
                        R v;
                        Throwable ex;
                        if (this.cancelled) {
                            this.cancelAll();
                            return;
                        }
                        if (em == FluxConcatMap.ErrorMode.IMMEDIATE && (ex = this.error) != null) {
                            this.current = null;
                            inner.cancel();
                            this.cancelAll();
                            a.onError(ex);
                            return;
                        }
                        d = inner.isDone();
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex3) {
                            this.current = null;
                            inner.cancel();
                            ex3 = Operators.onOperatorError(ex3);
                            this.cancelAll();
                            a.onError(ex3);
                            return;
                        }
                        boolean bl = empty = v == null;
                        if (d && empty) {
                            inner = null;
                            this.current = null;
                            this.s.request(1L);
                            continueNextSource = true;
                            break;
                        }
                        if (empty) break;
                        a.onNext(v);
                        ++e;
                        inner.requestOne();
                    }
                    if (e == r) {
                        Throwable ex;
                        if (this.cancelled) {
                            this.cancelAll();
                            return;
                        }
                        if (em == FluxConcatMap.ErrorMode.IMMEDIATE && (ex = this.error) != null) {
                            this.current = null;
                            inner.cancel();
                            this.cancelAll();
                            a.onError(ex);
                            return;
                        }
                        d = inner.isDone();
                        boolean empty = q.isEmpty();
                        if (d && empty) {
                            inner = null;
                            this.current = null;
                            this.s.request(1L);
                            continueNextSource = true;
                        }
                    }
                }
                if (e == 0L || r == Long.MAX_VALUE) continue;
                REQUESTED.addAndGet(this, -e);
            } while (continueNextSource || (missed = WIP.addAndGet(this, -missed)) != 0);
        }
    }
}

