/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Cancellation;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

final class MonoDelay
extends Mono<Long> {
    final Scheduler timedScheduler;
    final long delay;
    final TimeUnit unit;

    MonoDelay(long delay, TimeUnit unit, Scheduler timedScheduler) {
        this.delay = delay;
        this.unit = Objects.requireNonNull(unit, "unit");
        this.timedScheduler = Objects.requireNonNull(timedScheduler, "timedScheduler");
    }

    public void subscribe(Subscriber<? super Long> s) {
        MonoDelayRunnable r = new MonoDelayRunnable(s);
        s.onSubscribe((Subscription)r);
        Cancellation f = this.timedScheduler.schedule(r, this.delay, this.unit);
        if (f == Scheduler.REJECTED) {
            if (r.cancel != Flux.CANCELLED && r.cancel != MonoDelayRunnable.FINISHED) {
                s.onError((Throwable)Operators.onRejectedExecution(r, null, null));
            }
        } else {
            r.setCancel(f);
        }
    }

    static final class MonoDelayRunnable
    implements Runnable,
    InnerProducer<Long> {
        final Subscriber<? super Long> actual;
        volatile Cancellation cancel;
        static final AtomicReferenceFieldUpdater<MonoDelayRunnable, Cancellation> CANCEL = AtomicReferenceFieldUpdater.newUpdater(MonoDelayRunnable.class, Cancellation.class, "cancel");
        volatile boolean requested;
        static final Disposable FINISHED = () -> {};

        MonoDelayRunnable(Subscriber<? super Long> actual) {
            this.actual = actual;
        }

        public void setCancel(Cancellation cancel) {
            if (!CANCEL.compareAndSet(this, null, cancel)) {
                cancel.dispose();
            }
        }

        @Override
        public Subscriber<? super Long> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: {
                    return this.cancel == FINISHED;
                }
                case CANCELLED: {
                    return this.cancel == Flux.CANCELLED;
                }
                case PARENT: {
                    return this.actual;
                }
            }
            return InnerProducer.super.scan(key);
        }

        @Override
        public void run() {
            if (this.requested) {
                try {
                    if (CANCEL.getAndSet(this, FINISHED) != Flux.CANCELLED) {
                        this.actual.onNext((Object)0L);
                        this.actual.onComplete();
                    }
                }
                catch (Throwable t) {
                    this.actual.onError(Operators.onOperatorError(t));
                }
            } else {
                this.actual.onError((Throwable)Exceptions.failWithOverflow("Could not emit value due to lack of requests"));
            }
        }

        public void cancel() {
            Cancellation c = this.cancel;
            if (c != Flux.CANCELLED && c != FINISHED && (c = CANCEL.getAndSet(this, Flux.CANCELLED)) != null && c != Flux.CANCELLED && c != FINISHED) {
                c.dispose();
            }
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                this.requested = true;
            }
        }
    }
}

