/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxMap;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSource;

final class MonoMap<T, R>
extends MonoSource<T, R> {
    final Function<? super T, ? extends R> mapper;

    MonoMap(Mono<? extends T> source, Function<? super T, ? extends R> mapper) {
        super(source);
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        if (s instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)s;
            this.source.subscribe(new FluxMap.MapConditionalSubscriber<T, R>(cs, this.mapper));
            return;
        }
        this.source.subscribe(new FluxMap.MapSubscriber<T, R>(s, this.mapper));
    }
}

