/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;

final class SerializedSubscriber<T>
implements InnerOperator<T, T> {
    final Subscriber<? super T> actual;
    boolean emitting;
    boolean missed;
    volatile boolean done;
    volatile boolean cancelled;
    LinkedArrayNode<T> head;
    LinkedArrayNode<T> tail;
    Throwable error;
    Subscription s;

    SerializedSubscriber(Subscriber<? super T> actual) {
        this.actual = actual;
    }

    public void onSubscribe(Subscription s) {
        if (Operators.validate(this.s, s)) {
            this.s = s;
            this.actual.onSubscribe((Subscription)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(T t) {
        if (this.cancelled || this.done) {
            return;
        }
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            if (this.cancelled || this.done) {
                return;
            }
            if (this.emitting) {
                this.serAdd(t);
                this.missed = true;
                return;
            }
            this.emitting = true;
        }
        this.actual.onNext(t);
        this.serDrainLoop(this.actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable t) {
        if (this.cancelled || this.done) {
            return;
        }
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            if (this.cancelled || this.done) {
                return;
            }
            this.done = true;
            this.error = t;
            if (this.emitting) {
                this.missed = true;
                return;
            }
        }
        this.actual.onError(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        if (this.cancelled || this.done) {
            return;
        }
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            if (this.cancelled || this.done) {
                return;
            }
            this.done = true;
            if (this.emitting) {
                this.missed = true;
                return;
            }
        }
        this.actual.onComplete();
    }

    public void request(long n) {
        this.s.request(n);
    }

    public void cancel() {
        this.cancelled = true;
        this.s.cancel();
    }

    void serAdd(T value) {
        LinkedArrayNode<T> t = this.tail;
        if (t == null) {
            t = new LinkedArrayNode<T>(value);
            this.head = t;
            this.tail = t;
        } else if (t.count == 16) {
            LinkedArrayNode<T> n = new LinkedArrayNode<T>(value);
            t.next = n;
            this.tail = n;
        } else {
            t.array[t.count++] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serDrainLoop(Subscriber<? super T> actual) {
        boolean d;
        do {
            LinkedArrayNode<T> n;
            Throwable e;
            if (this.cancelled) {
                return;
            }
            SerializedSubscriber serializedSubscriber = this;
            synchronized (serializedSubscriber) {
                if (this.cancelled) {
                    return;
                }
                if (!this.missed) {
                    this.emitting = false;
                    return;
                }
                this.missed = false;
                d = this.done;
                e = this.error;
                n = this.head;
                this.head = null;
                this.tail = null;
            }
            while (n != null) {
                T[] arr = n.array;
                int c = n.count;
                for (int i = 0; i < c; ++i) {
                    if (this.cancelled) {
                        return;
                    }
                    actual.onNext(arr[i]);
                }
                n = n.next;
            }
            if (this.cancelled) {
                return;
            }
            if (e == null) continue;
            actual.onError(e);
            return;
        } while (!d);
        actual.onComplete();
    }

    @Override
    public Subscriber<? super T> actual() {
        return this.actual;
    }

    @Override
    public Object scan(Scannable.Attr key) {
        switch (key) {
            case PARENT: {
                return this.s;
            }
            case ERROR: {
                return this.error;
            }
            case BUFFERED: {
                return this.producerCapacity();
            }
            case CAPACITY: {
                return 16;
            }
            case CANCELLED: {
                return this.cancelled;
            }
            case TERMINATED: {
                return this.done;
            }
        }
        return InnerOperator.super.scan(key);
    }

    long producerCapacity() {
        LinkedArrayNode<T> node = this.tail;
        if (node != null) {
            return node.count;
        }
        return 0L;
    }

    static final class LinkedArrayNode<T> {
        static final int DEFAULT_CAPACITY = 16;
        final T[] array = new Object[16];
        int count;
        LinkedArrayNode<T> next;

        LinkedArrayNode(T value) {
            this.array[0] = value;
            this.count = 1;
        }
    }
}

