/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class ResolverSet
implements ValueResolver<ResolverSetResult>,
Initialisable {
    private Map<String, ValueResolver> resolvers = new LinkedHashMap<String, ValueResolver>();
    private boolean dynamic = false;
    private final MuleContext muleContext;
    private Function<Event, Optional<ConfigurationInstance>> configProvider;

    public ResolverSet(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public ResolverSet add(String key, ValueResolver resolver) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (String)"key cannot be null");
        Preconditions.checkArgument((resolver != null ? 1 : 0) != 0, (String)"resolver cannot be null");
        if (this.resolvers.put(key, resolver) != null) {
            throw new IllegalStateException("A value was already given for key " + key);
        }
        if (resolver.isDynamic()) {
            this.dynamic = true;
        }
        return this;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public ResolverSetResult resolve(ValueResolvingContext context) throws MuleException {
        ResolverSetResult.Builder builder = this.getResolverSetBuilder();
        for (Map.Entry<String, ValueResolver> entry : this.resolvers.entrySet()) {
            builder.add(entry.getKey(), this.resolveValue(entry.getValue(), context));
        }
        return builder.build();
    }

    private Object resolveValue(ValueResolver<?> resolver, ValueResolvingContext context) throws MuleException {
        TypedValue typedValue;
        Object objectValue;
        Object value = resolver.resolve(context);
        if (value instanceof ValueResolver) {
            return this.resolveValue((ValueResolver)value, context);
        }
        if (value instanceof CursorProvider) {
            return ((CursorProvider)value).openCursor();
        }
        if (value instanceof TypedValue && (objectValue = (typedValue = (TypedValue)value).getValue()) instanceof CursorProvider) {
            Cursor cursor = ((CursorProvider)objectValue).openCursor();
            return new TypedValue((Object)cursor, DataType.builder().type(cursor.getClass()).mediaType(typedValue.getDataType().getMediaType()).build());
        }
        return value;
    }

    public Map<String, ValueResolver> getResolvers() {
        return ImmutableMap.copyOf(this.resolvers);
    }

    public void initialise() {
        try {
            for (ValueResolver valueResolver : this.resolvers.values()) {
                this.muleContext.getInjector().inject((Object)valueResolver);
                LifecycleUtils.initialiseIfNeeded((Object)valueResolver);
            }
        }
        catch (MuleException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    ResolverSetResult.Builder getResolverSetBuilder() {
        return ResolverSetResult.newBuilder();
    }
}

