/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.splash;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.agent.Agent;
import org.mule.runtime.core.api.util.NetworkUtils;
import org.mule.runtime.core.config.MuleManifest;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.internal.util.splash.SplashScreen;

public class ServerStartupSplashScreen
extends SplashScreen {
    @Override
    protected void doHeader(MuleContext context) {
        String notset = CoreMessages.notSet().getMessage();
        Manifest mf = MuleManifest.getManifest();
        Attributes att = mf.getMainAttributes();
        if (att.values().size() > 0) {
            this.header.add(StringUtils.defaultString((String)MuleManifest.getProductDescription(), (String)notset));
            this.header.add(CoreMessages.version().getMessage() + " Build: " + StringUtils.defaultString((String)MuleManifest.getBuildNumber(), (String)notset));
            this.header.add(StringUtils.defaultString((String)MuleManifest.getVendorName(), (String)notset));
            this.header.add(StringUtils.defaultString((String)MuleManifest.getProductMoreInfo(), (String)notset));
        } else {
            this.header.add(CoreMessages.versionNotSet().getMessage());
        }
        this.header.add(" ");
        if (context.getStartDate() > 0L) {
            this.header.add(CoreMessages.serverStartedAt(context.getStartDate()).getMessage());
        }
        this.header.add("Server ID: " + context.getConfiguration().getId());
        this.header.add("JDK: " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.info") + ")");
        this.header.add("OS encoding: " + System.getProperty("file.encoding") + ", Mule encoding: " + context.getConfiguration().getDefaultEncoding());
        String patch = System.getProperty("sun.os.patch.level", null);
        this.header.add("OS: " + System.getProperty("os.name") + (patch != null && !"unknown".equalsIgnoreCase(patch) ? " - " + patch : "") + " (" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + ")");
        try {
            InetAddress host = NetworkUtils.getLocalHost();
            this.header.add("Host: " + host.getHostName() + " (" + host.getHostAddress() + ")");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.header.add(" ");
    }

    @Override
    protected void doFooter(MuleContext context) {
        Collection<Agent> agents;
        if (!this.body.isEmpty()) {
            this.footer.add(" ");
        }
        if ((agents = context.getRegistry().lookupObjects(Agent.class)).size() == 0) {
            this.footer.add(CoreMessages.agentsRunning().getMessage() + " " + CoreMessages.none().getMessage());
        } else {
            this.footer.add(CoreMessages.agentsRunning().getMessage());
            for (Agent agent : agents) {
                this.footer.add("  " + agent.getDescription());
            }
        }
    }
}

