/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.routing.RoutingException;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.routing.IdempotentMessageValidator;
import org.mule.runtime.core.transformer.simple.ByteArrayToHexString;
import org.mule.runtime.core.transformer.simple.SerializableToByteArray;

public class IdempotentSecureHashMessageValidator
extends IdempotentMessageValidator {
    private String messageDigestAlgorithm = "SHA-256";
    private final SerializableToByteArray objectToByteArray = new SerializableToByteArray();
    private final ByteArrayToHexString byteArrayToHexString = new ByteArrayToHexString();

    @Override
    protected String getIdForEvent(Event event) throws MuleException {
        try {
            Object payload = event.getMessage().getPayload().getValue();
            byte[] bytes = (byte[])this.objectToByteArray.transform(payload);
            MessageDigest md = MessageDigest.getInstance(this.messageDigestAlgorithm);
            byte[] digestedBytes = md.digest(bytes);
            return (String)this.byteArrayToHexString.transform(digestedBytes);
        }
        catch (NoSuchAlgorithmException nsa) {
            throw new RoutingException(this, nsa);
        }
        catch (TransformerException te) {
            throw new RoutingException(this, (Throwable)((Object)te));
        }
    }

    public String getMessageDigestAlgorithm() {
        return this.messageDigestAlgorithm;
    }

    public void setMessageDigestAlgorithm(String messageDigestAlgorithm) {
        this.messageDigestAlgorithm = messageDigestAlgorithm;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
        this.objectToByteArray.setMuleContext(this.muleContext);
        this.byteArrayToHexString.setMuleContext(this.muleContext);
    }
}

