/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.parameter;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionDefinitionParser;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingContext;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.TopLevelParameterObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;

public class ObjectTypeParameterParser
extends ExtensionDefinitionParser {
    private final ObjectType type;
    private final ClassLoader classLoader;
    private final DslElementSyntax typeDsl;
    private final String name;
    private final String namespace;

    public ObjectTypeParameterParser(ComponentBuildingDefinition.Builder definition, ObjectType type, ClassLoader classLoader, DslSyntaxResolver dslResolver, ExtensionParsingContext context) {
        super(definition, dslResolver, context);
        this.type = type;
        this.classLoader = classLoader;
        this.typeDsl = (DslElementSyntax)dslResolver.resolve((MetadataType)type).orElseThrow(() -> new IllegalArgumentException(String.format("Non parseable object of type [%s]", ExtensionMetadataTypeUtils.getId((MetadataType)type))));
        this.name = this.typeDsl.getElementName();
        this.namespace = this.typeDsl.getPrefix();
    }

    public ObjectTypeParameterParser(ComponentBuildingDefinition.Builder definition, String name, String namespace, ObjectType type, ClassLoader classLoader, DslSyntaxResolver dslResolver, ExtensionParsingContext context) {
        super(definition, dslResolver, context);
        this.name = name;
        this.namespace = namespace;
        this.type = type;
        this.classLoader = classLoader;
        this.typeDsl = (DslElementSyntax)dslResolver.resolve((MetadataType)type).orElseThrow(() -> new IllegalArgumentException(String.format("Non parseable object [%s:%s] of type [%s]", name, namespace, ExtensionMetadataTypeUtils.getId((MetadataType)type))));
    }

    @Override
    protected void doParse(ComponentBuildingDefinition.Builder definitionBuilder) throws ConfigurationException {
        definitionBuilder.withIdentifier(this.name).withNamespace(this.namespace).asNamed().withTypeDefinition(TypeDefinition.fromType(ValueResolver.class)).withObjectFactoryType(TopLevelParameterObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue((Object)this.type).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue((Object)this.classLoader).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build());
        this.parseFields(this.type, this.typeDsl);
    }
}

