/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiFunction;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;

final class FluxZipIterable<T, U, R>
extends FluxSource<T, R> {
    final Iterable<? extends U> other;
    final BiFunction<? super T, ? super U, ? extends R> zipper;

    FluxZipIterable(Flux<? extends T> source, Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        super(source);
        this.other = Objects.requireNonNull(other, "other");
        this.zipper = Objects.requireNonNull(zipper, "zipper");
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        boolean b;
        Iterator<U> it;
        try {
            it = Objects.requireNonNull(this.other.iterator(), "The other iterable produced a null iterator");
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        try {
            b = it.hasNext();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (!b) {
            Operators.complete(s);
            return;
        }
        this.source.subscribe(new ZipSubscriber<T, U, R>(s, it, this.zipper));
    }

    static final class ZipSubscriber<T, U, R>
    implements InnerOperator<T, R> {
        final Subscriber<? super R> actual;
        final Iterator<? extends U> it;
        final BiFunction<? super T, ? super U, ? extends R> zipper;
        Subscription s;
        boolean done;

        ZipSubscriber(Subscriber<? super R> actual, Iterator<? extends U> it, BiFunction<? super T, ? super U, ? extends R> zipper) {
            this.actual = actual;
            this.it = it;
            this.zipper = zipper;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: {
                    return this.done;
                }
                case PARENT: {
                    return this.s;
                }
            }
            return InnerOperator.super.scan(key);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            boolean b;
            R r;
            U u;
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            try {
                u = this.it.next();
            }
            catch (Throwable e) {
                this.done = true;
                this.actual.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            try {
                r = Objects.requireNonNull(this.zipper.apply(t, u), "The zipper returned a null value");
            }
            catch (Throwable e) {
                this.done = true;
                this.actual.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            this.actual.onNext(r);
            try {
                b = this.it.hasNext();
            }
            catch (Throwable e) {
                this.done = true;
                this.actual.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            if (!b) {
                this.done = true;
                this.s.cancel();
                this.actual.onComplete();
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public Subscriber<? super R> actual() {
            return this.actual;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

