/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.expression.transformers;

import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.expression.transformers.ExpressionArgument;
import org.mule.runtime.core.transformer.AbstractMessageTransformer;

public abstract class AbstractExpressionTransformer
extends AbstractMessageTransformer {
    protected List<ExpressionArgument> arguments;

    public AbstractExpressionTransformer() {
        this.registerSourceType(DataType.OBJECT);
        this.setReturnDataType(DataType.OBJECT);
        this.arguments = new ArrayList<ExpressionArgument>(4);
    }

    public void addArgument(ExpressionArgument argument) {
        this.arguments.add(argument);
    }

    public boolean removeArgument(ExpressionArgument argument) {
        return this.arguments.remove(argument);
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.arguments == null || this.arguments.size() == 0) {
            throw new InitialisationException(CoreMessages.objectIsNull("arguments[]"), (Initialisable)this);
        }
        for (ExpressionArgument argument : this.arguments) {
            argument.setMuleContext(this.muleContext);
            argument.setExpressionEvaluationClassLoader(Thread.currentThread().getContextClassLoader());
            try {
                argument.validate();
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    public List<ExpressionArgument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<ExpressionArgument> arguments) {
        this.arguments = arguments;
    }
}

