/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.Declarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasModelProperties;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclarer;
import org.mule.runtime.extension.api.annotation.Extensible;
import org.mule.runtime.extension.api.annotation.ExtensionOf;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.AbstractModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ExtendingOperationModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.OperationExecutorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.internal.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.internal.loader.java.type.WithOperationContainers;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.runtime.execution.ReflectiveOperationExecutorFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.springframework.core.ResolvableType;

final class OperationModelLoaderDelegate
extends AbstractModelLoaderDelegate {
    private static final String OPERATION = "Operation";
    private final Map<MethodElement, OperationDeclarer> operationDeclarers = new HashMap<MethodElement, OperationDeclarer>();

    OperationModelLoaderDelegate(DefaultJavaModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer declarer, WithOperationContainers operationContainers) {
        operationContainers.getOperationContainers().forEach(operationContainer -> this.declareOperations(extensionDeclarer, declarer, (OperationContainerElement)operationContainer));
    }

    void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer declarer, OperationContainerElement operationsContainer) {
        this.declareOperations(extensionDeclarer, declarer, operationsContainer.getDeclaringClass(), operationsContainer.getOperations(), true);
    }

    void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer declarer, Class<?> methodOwnerClass, List<MethodElement> operations, boolean supportsConfig) {
        for (MethodElement operationMethod : operations) {
            Class declaringClass = methodOwnerClass != null ? methodOwnerClass : operationMethod.getDeclaringClass();
            this.checkOperationIsNotAnExtension(declaringClass);
            Method method = operationMethod.getMethod();
            Optional<ExtensionParameter> configParameter = this.loader.getConfigParameter(operationMethod);
            Optional<ExtensionParameter> connectionParameter = this.loader.getConnectionParameter(operationMethod);
            if (this.loader.isInvalidConfigSupport(supportsConfig, configParameter, connectionParameter)) {
                throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' is defined at the extension level but it requires a config. Remove such parameter or move the operation to the proper config", method.getName()));
            }
            HasOperationDeclarer actualDeclarer = (HasOperationDeclarer)this.loader.selectDeclarerBasedOnConfig(extensionDeclarer, (Declarer)declarer, configParameter, connectionParameter);
            if (this.operationDeclarers.containsKey(operationMethod)) {
                actualDeclarer.withOperation(this.operationDeclarers.get(operationMethod));
                continue;
            }
            OperationDeclarer operation = (OperationDeclarer)((OperationDeclarer)actualDeclarer.withOperation(operationMethod.getAlias()).withModelProperty((ModelProperty)new ImplementingMethodModelProperty(method))).withModelProperty((ModelProperty)new OperationExecutorModelProperty(new ReflectiveOperationExecutorFactory(declaringClass, method)));
            this.loader.addExceptionEnricher(operationMethod, (HasModelProperties)operation);
            this.processComponentConnectivity((ComponentDeclarer)operation, operationMethod, operationMethod);
            if (!this.processNonBlockingOperation(operation, operationMethod)) {
                operation.blocking(true);
                operation.withOutputAttributes().ofType(IntrospectionUtils.getMethodReturnAttributesType(method, this.loader.getTypeLoader()));
                if (this.isAutoPaging(operationMethod)) {
                    ((OperationDeclarer)operation.supportsStreaming(true)).withOutput().ofType(IntrospectionUtils.getMethodReturnType(method, this.loader.getTypeLoader()));
                    this.addPagedOperationModelProperty(operationMethod, operation, supportsConfig);
                    this.processPagingTx(operation, method);
                } else {
                    MetadataType outputType = IntrospectionUtils.getMethodReturnType(method, this.loader.getTypeLoader());
                    operation.withOutput().ofType(outputType);
                    this.handleByteStreaming(method, operation, outputType);
                }
            }
            this.addExecutionType(operation, operationMethod);
            ParameterDeclarationContext declarationContext = new ParameterDeclarationContext(OPERATION, (NamedDeclaration)operation.getDeclaration());
            this.loader.getMethodParametersLoader().declare((ParameterizedDeclarer)operation, operationMethod.getParameters(), declarationContext);
            this.calculateExtendedTypes(declaringClass, method, operation);
            this.operationDeclarers.put(operationMethod, operation);
        }
    }

    private void handleByteStreaming(Method method, OperationDeclarer operation, MetadataType outputType) {
        operation.supportsStreaming(ExtensionMetadataTypeUtils.isInputStream((MetadataType)outputType) || method.getAnnotation(Streaming.class) != null);
    }

    private boolean processNonBlockingOperation(OperationDeclarer operation, MethodElement operationMethod) {
        List callbackParameters = operationMethod.getParameters().stream().filter(p -> CompletionCallback.class.equals((Object)p.getType().getDeclaringClass())).collect(Collectors.toList());
        if (callbackParameters.isEmpty()) {
            return false;
        }
        if (callbackParameters.size() > 1) {
            throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' defines more than one %s parameters. Only one is allowed", operationMethod.getAlias(), CompletionCallback.class.getSimpleName()));
        }
        if (!IntrospectionUtils.isVoid(operationMethod.getMethod())) {
            throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' has a parameter of type %s but is not void. Non-blocking operations have to be declared as void and the return type provided through the callback", operationMethod.getAlias(), CompletionCallback.class.getSimpleName()));
        }
        ExtensionParameter callbackParameter = (ExtensionParameter)callbackParameters.get(0);
        Parameter methodParameter = (Parameter)callbackParameter.getDeclaringElement();
        List<MetadataType> genericTypes = IntrospectionUtils.getGenerics(methodParameter.getParameterizedType(), this.loader.getTypeLoader());
        if (genericTypes.isEmpty()) {
            throw new IllegalParameterModelDefinitionException(String.format("Generics are mandatory on the %s parameter of Operation '%s'", CompletionCallback.class.getSimpleName(), operationMethod.getAlias()));
        }
        operation.withOutput().ofType(genericTypes.get(0));
        operation.withOutputAttributes().ofType(genericTypes.get(1));
        operation.blocking(false);
        this.handleByteStreaming(operationMethod.getMethod(), operation, genericTypes.get(0));
        return true;
    }

    private void addExecutionType(OperationDeclarer operationDeclarer, MethodElement operationMethod) {
        operationMethod.getAnnotation(Execution.class).ifPresent(a -> {
            OperationDeclarer cfr_ignored_0 = (OperationDeclarer)operationDeclarer.withExecutionType(a.value());
        });
    }

    private void checkOperationIsNotAnExtension(Class<?> operationType) {
        if (operationType.isAssignableFrom(this.getExtensionType()) || this.getExtensionType().isAssignableFrom(operationType)) {
            throw new IllegalOperationModelDefinitionException(String.format("Operation class '%s' cannot be the same class (nor a derivative) of the extension class '%s", operationType.getName(), this.getExtensionType().getName()));
        }
    }

    private void calculateExtendedTypes(Class<?> actingClass, Method method, OperationDeclarer operation) {
        ExtensionOf extensionOf = method.getAnnotation(ExtensionOf.class);
        if (extensionOf == null) {
            extensionOf = actingClass.getAnnotation(ExtensionOf.class);
        }
        if (extensionOf != null) {
            operation.withModelProperty(new ExtendingOperationModelProperty(extensionOf.value()));
        } else if (this.isExtensible()) {
            operation.withModelProperty(new ExtendingOperationModelProperty(this.getExtensionType()));
        }
    }

    private void addPagedOperationModelProperty(MethodElement operationMethod, OperationDeclarer operation, boolean supportsConfig) {
        if (!supportsConfig) {
            throw new IllegalOperationModelDefinitionException(String.format("Paged operation '%s' is defined at the extension level but it requires a config, since connections are required for paging", operationMethod.getName()));
        }
        operation.withModelProperty((ModelProperty)new PagedOperationModelProperty());
        operation.requiresConnection(true);
    }

    private void processPagingTx(OperationDeclarer operation, Method method) {
        ResolvableType connectionType = IntrospectionUtils.getMethodType(method).getGeneric(new int[]{0});
        operation.transactional(TransactionalConnection.class.isAssignableFrom(connectionType.getRawClass()));
    }

    private boolean isAutoPaging(MethodElement operationMethod) {
        return PagingProvider.class.isAssignableFrom(operationMethod.getReturnType());
    }

    private boolean isExtensible() {
        return this.getExtensionType().getAnnotation(Extensible.class) != null;
    }
}

