/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Iterator;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.FluxFirstEmitting;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoFirst<T>
extends Mono<T> {
    final Mono<? extends T>[] array;
    final Iterable<? extends Mono<? extends T>> iterable;

    @SafeVarargs
    MonoFirst(Mono<? extends T> ... array) {
        this.array = Objects.requireNonNull(array, "array");
        this.iterable = null;
    }

    MonoFirst(Iterable<? extends Mono<? extends T>> iterable) {
        this.array = null;
        this.iterable = Objects.requireNonNull(iterable);
    }

    Mono<T> orAdditionalSource(Mono<? extends T> other) {
        if (this.array != null) {
            int n = this.array.length;
            Mono[] newArray = new Mono[n + 1];
            System.arraycopy(this.array, 0, newArray, 0, n);
            newArray[n] = other;
            return new MonoFirst<T>(newArray);
        }
        return null;
    }

    public void subscribe(Subscriber<? super T> s) {
        int n;
        Mono<? extends T>[] a;
        block13: {
            a = this.array;
            if (a == null) {
                Iterator<Mono<T>> it;
                n = 0;
                a = new Publisher[8];
                try {
                    it = Objects.requireNonNull(this.iterable.iterator(), "The iterator returned is null");
                }
                catch (Throwable e) {
                    Operators.error(s, Operators.onOperatorError(e));
                    return;
                }
                while (true) {
                    Publisher p;
                    boolean b;
                    try {
                        b = it.hasNext();
                    }
                    catch (Throwable e) {
                        Operators.error(s, Operators.onOperatorError(e));
                        return;
                    }
                    if (!b) break block13;
                    try {
                        p = Objects.requireNonNull(it.next(), "The Publisher returned by the iterator is null");
                    }
                    catch (Throwable e) {
                        Operators.error(s, Operators.onOperatorError(e));
                        return;
                    }
                    if (n == a.length) {
                        Publisher[] c = new Publisher[n + (n >> 2)];
                        System.arraycopy(a, 0, c, 0, n);
                        a = c;
                    }
                    a[n++] = p;
                }
            }
            n = a.length;
        }
        if (n == 0) {
            Operators.complete(s);
            return;
        }
        if (n == 1) {
            Mono<? extends T> p = a[0];
            if (p == null) {
                Operators.error(s, Operators.onOperatorError(new NullPointerException("The single source Publisher is null")));
            } else {
                p.subscribe(s);
            }
            return;
        }
        FluxFirstEmitting.RaceCoordinator<? super T> coordinator = new FluxFirstEmitting.RaceCoordinator<T>(n);
        coordinator.subscribe(a, n, s);
    }
}

