/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.mvel.datatype;

import java.lang.reflect.Field;
import org.mule.mvel2.ast.ASTNode;
import org.mule.mvel2.ast.AssignmentNode;
import org.mule.mvel2.ast.DeepAssignmentNode;
import org.mule.mvel2.compiler.AccessorNode;
import org.mule.mvel2.compiler.CompiledAccExpression;
import org.mule.mvel2.compiler.ExecutableLiteral;
import org.mule.mvel2.optimizers.impl.refl.nodes.MapAccessor;
import org.mule.mvel2.optimizers.impl.refl.nodes.MapAccessorNest;
import org.mule.mvel2.optimizers.impl.refl.nodes.VariableAccessor;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.el.mvel.datatype.AbstractEnricherDataTypePropagator;

public abstract class AbstractVariableEnricherDataTypePropagator
extends AbstractEnricherDataTypePropagator {
    private final String propertyName;
    private final Field accExprFieldForMapSyntax;
    private final Field accExprFieldForDotSyntax;

    public AbstractVariableEnricherDataTypePropagator(String propertyName) {
        this.propertyName = propertyName;
        try {
            this.accExprFieldForMapSyntax = AssignmentNode.class.getDeclaredField("accExpr");
            this.accExprFieldForMapSyntax.setAccessible(true);
            this.accExprFieldForDotSyntax = DeepAssignmentNode.class.getDeclaredField("acc");
            this.accExprFieldForDotSyntax.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected boolean doPropagate(Event event, Event.Builder builder, TypedValue typedValue, ASTNode node) {
        AccessorNode nextNode;
        VariableAccessor variableAccessor;
        CompiledAccExpression compiledAccExpression;
        if (this.isAssignmentNode(node) && (compiledAccExpression = this.getCompiledAccExpression(node)).getAccessor() instanceof VariableAccessor && (variableAccessor = (VariableAccessor)compiledAccExpression.getAccessor()).getProperty().equals(this.propertyName) && (nextNode = variableAccessor.getNextNode()).getNextNode() == null) {
            String propertyName = null;
            if (nextNode instanceof MapAccessorNest) {
                MapAccessorNest mapAccesorNest = (MapAccessorNest)nextNode;
                if (mapAccesorNest.getProperty().isLiteralOnly()) {
                    propertyName = (String)((ExecutableLiteral)mapAccesorNest.getProperty()).getLiteral();
                }
            } else if (nextNode instanceof MapAccessor) {
                propertyName = (String)((MapAccessor)nextNode).getProperty();
            }
            if (propertyName != null && this.containsVariable(event, propertyName)) {
                propertyName = this.getUnescapedPropertyName(propertyName);
                this.addVariable(event, builder, typedValue, propertyName);
                return true;
            }
        }
        return false;
    }

    protected abstract void addVariable(Event var1, Event.Builder var2, TypedValue var3, String var4);

    protected abstract boolean containsVariable(Event var1, String var2);

    private String getUnescapedPropertyName(String propertyName) {
        if (propertyName.startsWith("'") && propertyName.endsWith("'")) {
            propertyName = propertyName.substring(1, propertyName.length() - 1);
        }
        return propertyName;
    }

    private boolean isAssignmentNode(ASTNode node) {
        return node instanceof AssignmentNode && ((AssignmentNode)node).getAssignmentVar().startsWith(this.propertyName) || node instanceof DeepAssignmentNode && ((DeepAssignmentNode)node).getAssignmentVar().startsWith(this.propertyName);
    }

    private CompiledAccExpression getCompiledAccExpression(ASTNode node) {
        try {
            if (node instanceof AssignmentNode) {
                return (CompiledAccExpression)this.accExprFieldForMapSyntax.get(node);
            }
            return (CompiledAccExpression)this.accExprFieldForDotSyntax.get(node);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

