/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.datatype;

import java.nio.charset.Charset;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.transformer.AbstractTransformer;

public class StringToMediaTypeTransformer
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 1;

    public StringToMediaTypeTransformer() {
        this.registerSourceType(DataType.STRING);
        this.setReturnDataType(DataType.builder().type(MediaType.class).build());
    }

    @Override
    protected Object doTransform(Object src, Charset enc) throws TransformerException {
        try {
            return DataType.builder().mediaType((String)src).build().getMediaType();
        }
        catch (Exception e) {
            throw new TransformerException(I18nMessageFactory.createStaticMessage((String)"Exception transforming to MediaType."), (Throwable)e);
        }
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

