/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.queue;

import java.io.Serializable;
import javax.transaction.xa.Xid;
import org.mule.runtime.core.internal.util.journal.queue.XaTxQueueTransactionJournal;
import org.mule.runtime.core.internal.util.queue.PersistentXaTransactionContext;
import org.mule.runtime.core.util.queue.QueueProvider;
import org.mule.runtime.core.util.queue.QueueStore;
import org.mule.runtime.core.util.queue.QueueTransactionContextFactory;
import org.mule.runtime.core.util.queue.QueueTypeTransactionContextAdapter;
import org.mule.runtime.core.util.queue.TransientQueueTransactionContext;
import org.mule.runtime.core.util.queue.TransientXaTransactionAdapter;
import org.mule.runtime.core.util.queue.XaQueueTransactionContext;
import org.mule.runtime.core.util.xa.AbstractXaTransactionContext;
import org.mule.runtime.core.util.xa.ResourceManagerException;

public class XaQueueTypeTransactionContextAdapter
extends AbstractXaTransactionContext
implements XaQueueTransactionContext,
QueueTransactionContextFactory<XaQueueTransactionContext> {
    private final XaTxQueueTransactionJournal xaTxQueueTransactionJournal;
    private final QueueProvider queueProvider;
    private final QueueTypeTransactionContextAdapter<XaQueueTransactionContext> delegate;
    private final Xid xid;

    public XaQueueTypeTransactionContextAdapter(XaTxQueueTransactionJournal xaTxQueueTransactionJournal, QueueProvider queueProvider, Xid xid) {
        this.xaTxQueueTransactionJournal = xaTxQueueTransactionJournal;
        this.queueProvider = queueProvider;
        this.xid = xid;
        this.delegate = new QueueTypeTransactionContextAdapter<XaQueueTransactionContext>(this);
    }

    @Override
    public XaQueueTransactionContext createPersistentTransactionContext() {
        return new PersistentXaTransactionContext(this.xaTxQueueTransactionJournal, this.queueProvider, this.xid);
    }

    @Override
    public XaQueueTransactionContext createTransientTransactionContext() {
        return new TransientXaTransactionAdapter(new TransientQueueTransactionContext());
    }

    @Override
    public void doCommit() throws ResourceManagerException {
        XaQueueTransactionContext transactionContext = this.delegate.getTransactionContext();
        if (transactionContext != null) {
            transactionContext.doCommit();
        }
    }

    @Override
    public void doRollback() throws ResourceManagerException {
        XaQueueTransactionContext transactionContext = this.delegate.getTransactionContext();
        if (transactionContext != null) {
            transactionContext.doRollback();
        }
    }

    @Override
    public void doPrepare() throws ResourceManagerException {
        XaQueueTransactionContext transactionContext = this.delegate.getTransactionContext();
        if (transactionContext != null) {
            transactionContext.doPrepare();
        }
    }

    @Override
    public boolean offer(QueueStore queue, Serializable item, long offerTimeout) throws InterruptedException {
        return this.delegate.offer(queue, item, offerTimeout);
    }

    @Override
    public void untake(QueueStore queue, Serializable item) throws InterruptedException {
        this.delegate.untake(queue, item);
    }

    @Override
    public void clear(QueueStore queue) throws InterruptedException {
        this.delegate.clear(queue);
    }

    @Override
    public Serializable poll(QueueStore queue, long pollTimeout) throws InterruptedException {
        return this.delegate.poll(queue, pollTimeout);
    }

    @Override
    public Serializable peek(QueueStore queue) throws InterruptedException {
        return this.delegate.peek(queue);
    }

    @Override
    public int size(QueueStore queue) {
        return this.delegate.size(queue);
    }
}

