/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.message;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.MultiPartPayload;
import org.mule.runtime.core.message.PartAttributes;

public class DefaultMultiPartPayload
implements Serializable,
MultiPartPayload {
    private static final long serialVersionUID = -1435622001805748221L;
    private static final String BODY_PART_NAME = "_body";
    public static final PartAttributes BODY_ATTRIBUTES = new PartAttributes("_body");
    private List<Message> parts;

    public DefaultMultiPartPayload(Message ... parts) {
        this(Arrays.asList(parts));
    }

    public DefaultMultiPartPayload(List<Message> parts) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Message part : parts) {
            if (!(part.getAttributes().getValue() instanceof PartAttributes)) {
                throw new IllegalArgumentException("Body parts may only have 'PartAttributes' as attributes.");
            }
            if (part.getPayload().getValue() instanceof MultiPartPayload) {
                builder.addAll((Iterable)((MultiPartPayload)part.getPayload().getValue()).getParts());
                continue;
            }
            builder.add((Object)part);
        }
        this.parts = builder.build();
    }

    public List<Message> getParts() {
        return this.parts;
    }

    public List<String> getPartNames() {
        return this.parts.stream().map(m -> this.getPartAttributes((Message)m).getName()).collect(Collectors.toList());
    }

    public Message getPart(String partName) {
        return this.parts.stream().filter(m -> partName.equals(this.getPartAttributes((Message)m).getName())).findFirst().get();
    }

    public Map<String, Message> getNamedParts() {
        return this.parts.stream().collect(Collectors.toMap(m -> this.getPartAttributes((Message)m).getName(), m -> m));
    }

    public Message getBodyPart() {
        return this.parts.stream().filter(m -> BODY_PART_NAME.equals(this.getPartAttributes((Message)m).getName())).findFirst().orElse(null);
    }

    public List<Message> getNonBodyParts() {
        return this.parts.stream().filter(m -> !BODY_PART_NAME.equals(this.getPartAttributes((Message)m).getName())).collect(Collectors.toList());
    }

    public boolean hasBodyPart() {
        return this.parts.stream().anyMatch(m -> BODY_PART_NAME.equals(this.getPartAttributes((Message)m).getName()));
    }

    private PartAttributes getPartAttributes(Message message) {
        return (PartAttributes)message.getAttributes().getValue();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.getPartNames() + "}";
    }
}

