/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.reactivestreams.Subscriber;
import reactor.core.Cancellation;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Operators;
import reactor.util.concurrent.QueueSupplier;

final class FluxCreate<T>
extends Flux<T> {
    final Consumer<? super FluxSink<T>> source;
    final FluxSink.OverflowStrategy backpressure;
    final CreateMode createMode;

    FluxCreate(Consumer<? super FluxSink<T>> source, FluxSink.OverflowStrategy backpressure, CreateMode createMode) {
        this.source = Objects.requireNonNull(source, "source");
        this.backpressure = Objects.requireNonNull(backpressure, "backpressure");
        this.createMode = createMode;
    }

    static <T> BaseSink<T> createSink(Subscriber<? super T> t, FluxSink.OverflowStrategy backpressure) {
        switch (backpressure) {
            case IGNORE: {
                return new IgnoreSink<T>(t);
            }
            case ERROR: {
                return new ErrorAsyncSink<T>(t);
            }
            case DROP: {
                return new DropAsyncSink<T>(t);
            }
            case LATEST: {
                return new LatestAsyncSink<T>(t);
            }
        }
        return new BufferAsyncSink<T>(t, QueueSupplier.SMALL_BUFFER_SIZE);
    }

    public void subscribe(Subscriber<? super T> t) {
        BaseSink<T> sink = FluxCreate.createSink(t, this.backpressure);
        t.onSubscribe(sink);
        try {
            this.source.accept(this.createMode == CreateMode.PUSH_PULL ? sink.serialize() : sink);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            sink.error(Operators.onOperatorError(ex));
        }
    }

    static final class SinkDisposable
    implements Disposable {
        Disposable onCancel;
        Disposable disposable;

        SinkDisposable(Disposable disposable, Disposable onCancel) {
            this.disposable = disposable;
            this.onCancel = onCancel;
        }

        @Override
        public void dispose() {
            if (this.disposable != null) {
                this.disposable.dispose();
            }
        }

        public void cancel() {
            if (this.onCancel != null) {
                this.onCancel.dispose();
            }
        }
    }

    static final class LatestAsyncSink<T>
    extends BaseSink<T> {
        final AtomicReference<T> queue = new AtomicReference();
        Throwable error;
        volatile boolean done;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<LatestAsyncSink> WIP = AtomicIntegerFieldUpdater.newUpdater(LatestAsyncSink.class, "wip");

        LatestAsyncSink(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public void next(T t) {
            this.queue.set(t);
            this.drain();
        }

        @Override
        public void error(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        @Override
        public void complete() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequestedFromDownstream() {
            this.drain();
        }

        @Override
        void onCancel() {
            if (WIP.getAndIncrement(this) == 0) {
                this.queue.lazySet(null);
            }
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            int missed = 1;
            Subscriber a = this.actual;
            AtomicReference<T> q = this.queue;
            do {
                boolean d;
                long e;
                long r = this.requested;
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q.lazySet(null);
                        return;
                    }
                    d = this.done;
                    Object o = q.getAndSet(null);
                    boolean bl = empty = o == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.error(ex);
                        } else {
                            super.complete();
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(o);
                }
                if (e == r) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q.lazySet(null);
                        return;
                    }
                    d = this.done;
                    boolean bl = empty = q.get() == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.error(ex);
                        } else {
                            super.complete();
                        }
                        return;
                    }
                }
                if (e == 0L) continue;
                Operators.produced(REQUESTED, this, e);
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case BUFFERED: {
                    return this.queue.get() == null ? 0 : 1;
                }
                case TERMINATED: {
                    return this.done;
                }
                case ERROR: {
                    return this.error;
                }
            }
            return super.scan(key);
        }
    }

    static final class BufferAsyncSink<T>
    extends BaseSink<T> {
        final Queue<T> queue;
        Throwable error;
        volatile boolean done;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<BufferAsyncSink> WIP = AtomicIntegerFieldUpdater.newUpdater(BufferAsyncSink.class, "wip");

        BufferAsyncSink(Subscriber<? super T> actual, int capacityHint) {
            super(actual);
            this.queue = QueueSupplier.unbounded(capacityHint).get();
        }

        @Override
        public void next(T t) {
            this.queue.offer(t);
            this.drain();
        }

        @Override
        public void error(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        @Override
        public void complete() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequestedFromDownstream() {
            this.drain();
        }

        @Override
        void onCancel() {
            if (WIP.getAndIncrement(this) == 0) {
                this.queue.clear();
            }
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            int missed = 1;
            Subscriber a = this.actual;
            Queue<T> q = this.queue;
            do {
                boolean d;
                long e;
                long r = this.requested;
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q.clear();
                        return;
                    }
                    d = this.done;
                    T o = q.poll();
                    boolean bl = empty = o == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.error(ex);
                        } else {
                            super.complete();
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(o);
                }
                if (e == r) {
                    if (this.isCancelled()) {
                        q.clear();
                        return;
                    }
                    d = this.done;
                    boolean empty = q.isEmpty();
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.error(ex);
                        } else {
                            super.complete();
                        }
                        return;
                    }
                }
                if (e == 0L) continue;
                Operators.produced(REQUESTED, this, e);
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case BUFFERED: {
                    return this.queue.size();
                }
                case TERMINATED: {
                    return this.done;
                }
                case ERROR: {
                    return this.error;
                }
            }
            return super.scan(key);
        }
    }

    static final class ErrorAsyncSink<T>
    extends NoOverflowBaseAsyncSink<T> {
        ErrorAsyncSink(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        void onOverflow() {
            this.error(Exceptions.failWithOverflow());
        }
    }

    static final class DropAsyncSink<T>
    extends NoOverflowBaseAsyncSink<T> {
        DropAsyncSink(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        void onOverflow() {
        }
    }

    static abstract class NoOverflowBaseAsyncSink<T>
    extends BaseSink<T> {
        NoOverflowBaseAsyncSink(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public final void next(T t) {
            if (this.isCancelled()) {
                return;
            }
            if (this.requested != 0L) {
                this.actual.onNext(t);
                Operators.produced(REQUESTED, this, 1L);
            } else {
                this.onOverflow();
            }
        }

        abstract void onOverflow();
    }

    static final class IgnoreSink<T>
    extends BaseSink<T> {
        IgnoreSink(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public void next(T t) {
            long r;
            if (this.isCancelled()) {
                return;
            }
            this.actual.onNext(t);
            while ((r = this.requested) != 0L && !REQUESTED.compareAndSet(this, r, r - 1L)) {
            }
        }
    }

    static abstract class BaseSink<T>
    implements FluxSink<T>,
    InnerProducer<T> {
        final Subscriber<? super T> actual;
        volatile Disposable disposable;
        static final AtomicReferenceFieldUpdater<BaseSink, Disposable> DISPOSABLE = AtomicReferenceFieldUpdater.newUpdater(BaseSink.class, Disposable.class, "disposable");
        volatile long requested;
        static final AtomicLongFieldUpdater<BaseSink> REQUESTED = AtomicLongFieldUpdater.newUpdater(BaseSink.class, "requested");
        volatile LongConsumer requestConsumer;
        static final AtomicReferenceFieldUpdater<BaseSink, LongConsumer> REQUEST_CONSUMER = AtomicReferenceFieldUpdater.newUpdater(BaseSink.class, LongConsumer.class, "requestConsumer");

        BaseSink(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void complete() {
            if (this.isCancelled()) {
                return;
            }
            try {
                this.actual.onComplete();
            }
            finally {
                this.disposeResource(false);
            }
        }

        @Override
        public void error(Throwable e) {
            if (this.isCancelled()) {
                return;
            }
            try {
                this.actual.onError(e);
            }
            finally {
                this.disposeResource(false);
            }
        }

        public final void cancel() {
            this.disposeResource(true);
            this.onCancel();
        }

        void disposeResource(boolean isCancel) {
            Disposable d = this.disposable;
            if (d != Flux.CANCELLED && (d = DISPOSABLE.getAndSet(this, Flux.CANCELLED)) != null && d != Flux.CANCELLED) {
                if (isCancel && d instanceof SinkDisposable) {
                    ((SinkDisposable)d).cancel();
                }
                d.dispose();
            }
        }

        @Override
        public long requestedFromDownstream() {
            return this.requested;
        }

        void onCancel() {
        }

        @Override
        public final boolean isCancelled() {
            return this.disposable == Flux.CANCELLED;
        }

        public final void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                LongConsumer consumer = this.requestConsumer;
                if (n > 0L && consumer != null && !this.isCancelled()) {
                    consumer.accept(n);
                }
                this.onRequestedFromDownstream();
            }
        }

        void onRequestedFromDownstream() {
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public FluxSink<T> onRequest(LongConsumer consumer) {
            this.onRequest(consumer, n -> {}, Long.MAX_VALUE);
            return this;
        }

        protected void onRequest(LongConsumer initialRequestConsumer, LongConsumer requestConsumer, long value) {
            if (!REQUEST_CONSUMER.compareAndSet(this, null, requestConsumer)) {
                throw new IllegalStateException("A consumer has already been assigned to consume requests");
            }
            if (value > 0L) {
                initialRequestConsumer.accept(value);
            }
        }

        @Override
        public final FluxSink<T> onCancel(Disposable d) {
            Disposable c;
            SinkDisposable sd;
            if (d != null && !DISPOSABLE.compareAndSet(this, null, sd = new SinkDisposable(null, d)) && (c = this.disposable) instanceof SinkDisposable) {
                SinkDisposable current = (SinkDisposable)c;
                if (current.onCancel == null) {
                    current.onCancel = d;
                } else {
                    d.dispose();
                }
            }
            return this;
        }

        @Override
        public final FluxSink<T> onDispose(Disposable d) {
            Disposable c;
            SinkDisposable sd;
            if (d != null && !DISPOSABLE.compareAndSet(this, null, sd = new SinkDisposable(d, null)) && (c = this.disposable) instanceof SinkDisposable) {
                SinkDisposable current = (SinkDisposable)c;
                if (current.disposable == null) {
                    current.disposable = d;
                } else {
                    d.dispose();
                }
            }
            return this;
        }

        @Override
        @Deprecated
        public final void setCancellation(final Cancellation c) {
            this.onDispose(new Disposable(){

                @Override
                public void dispose() {
                    c.dispose();
                }
            });
        }

        @Override
        public final FluxSink<T> serialize() {
            return new SerializedSink(this);
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: 
                case CANCELLED: {
                    return this.disposable == Flux.CANCELLED;
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
            }
            return InnerProducer.super.scan(key);
        }
    }

    static final class SerializedSink<T>
    implements FluxSink<T>,
    Scannable {
        final BaseSink<T> sink;
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<SerializedSink, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(SerializedSink.class, Throwable.class, "error");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<SerializedSink> WIP = AtomicIntegerFieldUpdater.newUpdater(SerializedSink.class, "wip");
        final Queue<T> queue;
        volatile boolean done;

        SerializedSink(BaseSink<T> sink) {
            this.sink = sink;
            this.queue = QueueSupplier.unbounded(16).get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void next(T t) {
            if (this.sink.isCancelled() || this.done) {
                return;
            }
            if (t == null) {
                throw new NullPointerException("t is null in sink.next(t)");
            }
            if (WIP.get(this) == 0 && WIP.compareAndSet(this, 0, 1)) {
                this.sink.next(t);
                if (WIP.decrementAndGet(this) == 0) {
                    return;
                }
            } else {
                Queue<T> q = this.queue;
                SerializedSink serializedSink = this;
                synchronized (serializedSink) {
                    q.offer(t);
                }
                if (WIP.getAndIncrement(this) != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void error(Throwable t) {
            if (this.sink.isCancelled() || this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            if (t == null) {
                throw new NullPointerException("t is null in sink.error(t)");
            }
            if (Exceptions.addThrowable(ERROR, this, t)) {
                this.done = true;
                this.drain();
            } else {
                Operators.onErrorDropped(t);
            }
        }

        @Override
        public void complete() {
            if (this.sink.isCancelled() || this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void drain() {
            if (WIP.getAndIncrement(this) == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            BaseSink<T> e = this.sink;
            Queue<T> q = this.queue;
            int missed = 1;
            while (true) {
                boolean empty;
                T v;
                if (e.isCancelled()) {
                    q.clear();
                    return;
                }
                if (ERROR.get(this) != null) {
                    q.clear();
                    e.error(Exceptions.terminate(ERROR, this));
                    return;
                }
                boolean d = this.done;
                try {
                    v = q.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    v = null;
                }
                boolean bl = empty = v == null;
                if (d && empty) {
                    e.complete();
                    return;
                }
                if (!empty) {
                    e.next(v);
                    continue;
                }
                if ((missed = WIP.addAndGet(this, -missed)) == 0) break;
            }
        }

        @Override
        public FluxSink<T> onRequest(LongConsumer consumer) {
            this.sink.onRequest(consumer, consumer, this.sink.requested);
            return this;
        }

        @Override
        public FluxSink<T> onCancel(Disposable d) {
            this.sink.onCancel(d);
            return this;
        }

        @Override
        public FluxSink<T> onDispose(Disposable d) {
            this.sink.onDispose(d);
            return this;
        }

        @Override
        @Deprecated
        public void setCancellation(Cancellation c) {
            this.sink.setCancellation(c);
        }

        @Override
        public long requestedFromDownstream() {
            return this.sink.requestedFromDownstream();
        }

        @Override
        public boolean isCancelled() {
            return this.sink.isCancelled();
        }

        @Override
        public FluxSink<T> serialize() {
            return this;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case BUFFERED: {
                    return this.queue.size();
                }
                case ERROR: {
                    return this.error;
                }
                case TERMINATED: {
                    return this.done;
                }
            }
            return null;
        }
    }

    static enum CreateMode {
        PUSH_ONLY,
        PUSH_PULL;

    }
}

