/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Cancellation;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

final class FluxPublishOn<T>
extends FluxSource<T, T>
implements Fuseable {
    final Scheduler scheduler;
    final boolean delayError;
    final Supplier<? extends Queue<T>> queueSupplier;
    final int prefetch;

    FluxPublishOn(Flux<? extends T> source, Scheduler scheduler, boolean delayError, int prefetch, Supplier<? extends Queue<T>> queueSupplier) {
        super(source);
        if (prefetch <= 0) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + prefetch);
        }
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
        this.delayError = delayError;
        this.prefetch = prefetch;
        this.queueSupplier = Objects.requireNonNull(queueSupplier, "queueSupplier");
    }

    @Override
    public long getPrefetch() {
        return this.prefetch;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        Scheduler.Worker worker;
        try {
            worker = Objects.requireNonNull(this.scheduler.createWorker(), "The scheduler returned a null worker");
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (s instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)s;
            this.source.subscribe(new PublishOnConditionalSubscriber(cs, this.scheduler, worker, this.delayError, this.prefetch, this.queueSupplier));
            return;
        }
        this.source.subscribe(new PublishOnSubscriber<T>(s, this.scheduler, worker, this.delayError, this.prefetch, this.queueSupplier));
    }

    static final class PublishOnConditionalSubscriber<T>
    implements Fuseable.QueueSubscription<T>,
    Runnable,
    InnerOperator<T, T> {
        final Fuseable.ConditionalSubscriber<? super T> actual;
        final Scheduler.Worker worker;
        final Scheduler scheduler;
        final boolean delayError;
        final int prefetch;
        final int limit;
        final Supplier<? extends Queue<T>> queueSupplier;
        Subscription s;
        Queue<T> queue;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<PublishOnConditionalSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(PublishOnConditionalSubscriber.class, "wip");
        volatile long requested;
        static final AtomicLongFieldUpdater<PublishOnConditionalSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(PublishOnConditionalSubscriber.class, "requested");
        int sourceMode;
        long produced;
        long consumed;
        boolean outputFused;

        PublishOnConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, Scheduler scheduler, Scheduler.Worker worker, boolean delayError, int prefetch, Supplier<? extends Queue<T>> queueSupplier) {
            this.actual = actual;
            this.worker = worker;
            this.scheduler = scheduler;
            this.delayError = delayError;
            this.prefetch = prefetch;
            this.queueSupplier = queueSupplier;
            this.limit = prefetch != Integer.MAX_VALUE ? prefetch - (prefetch >> 2) : Integer.MAX_VALUE;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                if (s instanceof Fuseable.QueueSubscription) {
                    Fuseable.QueueSubscription f = (Fuseable.QueueSubscription)s;
                    int m = f.requestFusion(7);
                    if (m == 1) {
                        this.sourceMode = 1;
                        this.queue = f;
                        this.done = true;
                        this.actual.onSubscribe(this);
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = 2;
                        this.queue = f;
                        this.actual.onSubscribe(this);
                        this.initialRequest();
                        return;
                    }
                }
                this.queue = this.queueSupplier.get();
                this.actual.onSubscribe(this);
                this.initialRequest();
            }
        }

        void initialRequest() {
            if (this.prefetch == Integer.MAX_VALUE) {
                this.s.request(Long.MAX_VALUE);
            } else {
                this.s.request((long)this.prefetch);
            }
        }

        public void onNext(T t) {
            if (t == null) {
                if (this.trySchedule() == Scheduler.REJECTED) {
                    throw Operators.onRejectedExecution(this, null, t);
                }
                return;
            }
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            if (!this.queue.offer(t)) {
                this.error = Operators.onOperatorError(this.s, Exceptions.failWithOverflow("Queue is full?!"), t);
                this.done = true;
            }
            if (this.trySchedule() == Scheduler.REJECTED) {
                throw Operators.onRejectedExecution(this, null, t);
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.error = t;
            this.done = true;
            if (this.trySchedule() == Scheduler.REJECTED) {
                throw Operators.onRejectedExecution(null, t, null);
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.trySchedule() == Scheduler.REJECTED && !this.worker.isDisposed()) {
                throw Operators.onRejectedExecution();
            }
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                if (this.trySchedule() == Scheduler.REJECTED && (!this.worker.isDisposed() || this.scheduler.isDisposed())) {
                    throw Operators.onRejectedExecution(this, null, null);
                }
            }
        }

        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.s.cancel();
            this.worker.dispose();
            if (WIP.getAndIncrement(this) == 0) {
                this.queue.clear();
            }
        }

        Cancellation trySchedule() {
            if (WIP.getAndIncrement(this) != 0) {
                return null;
            }
            return this.worker.schedule(this);
        }

        void runSync() {
            int missed = 1;
            Fuseable.ConditionalSubscriber<T> a = this.actual;
            Queue<T> q = this.queue;
            long e = this.produced;
            while (true) {
                long r = this.requested;
                while (e != r) {
                    T v;
                    try {
                        v = q.poll();
                    }
                    catch (Throwable ex) {
                        this.doError(a, Operators.onOperatorError(this.s, ex));
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (v == null) {
                        this.doComplete(a);
                        return;
                    }
                    if (!a.tryOnNext(v)) continue;
                    ++e;
                }
                if (this.cancelled) {
                    return;
                }
                if (q.isEmpty()) {
                    this.doComplete(a);
                    return;
                }
                int w = this.wip;
                if (missed == w) {
                    this.produced = e;
                    if ((missed = WIP.addAndGet(this, -missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        void runAsync() {
            int missed = 1;
            Fuseable.ConditionalSubscriber<T> a = this.actual;
            Queue<T> q = this.queue;
            long emitted = this.produced;
            long polled = this.consumed;
            while (true) {
                long r = this.requested;
                while (emitted != r) {
                    boolean empty;
                    T v;
                    boolean d = this.done;
                    try {
                        v = q.poll();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.s.cancel();
                        q.clear();
                        this.doError(a, Operators.onOperatorError(ex));
                        return;
                    }
                    boolean bl = empty = v == null;
                    if (this.checkTerminated(d, empty, a)) {
                        return;
                    }
                    if (empty) break;
                    if (a.tryOnNext(v)) {
                        ++emitted;
                    }
                    if (++polled != (long)this.limit) continue;
                    this.s.request(polled);
                    polled = 0L;
                }
                if (emitted == r && this.checkTerminated(this.done, q.isEmpty(), a)) {
                    return;
                }
                int w = this.wip;
                if (missed == w) {
                    this.produced = emitted;
                    this.consumed = polled;
                    if ((missed = WIP.addAndGet(this, -missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        void runBackfused() {
            int missed = 1;
            do {
                if (this.cancelled) {
                    return;
                }
                boolean d = this.done;
                this.actual.onNext(null);
                if (!d) continue;
                Throwable e = this.error;
                if (e != null) {
                    this.doError(this.actual, e);
                } else {
                    this.doComplete(this.actual);
                }
                return;
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        @Override
        public void run() {
            if (this.outputFused) {
                this.runBackfused();
            } else if (this.sourceMode == 1) {
                this.runSync();
            } else {
                this.runAsync();
            }
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
                case PARENT: {
                    return this.s;
                }
                case CANCELLED: {
                    return this.cancelled;
                }
                case TERMINATED: {
                    return this.done;
                }
                case BUFFERED: {
                    return this.queue != null ? this.queue.size() : 0;
                }
                case ERROR: {
                    return this.error;
                }
                case DELAY_ERROR: {
                    return this.delayError;
                }
                case PREFETCH: {
                    return this.prefetch;
                }
            }
            return InnerOperator.super.scan(key);
        }

        void doComplete(Subscriber<?> a) {
            try {
                a.onComplete();
            }
            finally {
                this.worker.dispose();
            }
        }

        void doError(Subscriber<?> a, Throwable e) {
            try {
                a.onError(e);
            }
            finally {
                this.worker.dispose();
            }
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a) {
            if (this.cancelled) {
                this.queue.clear();
                return true;
            }
            if (d) {
                if (this.delayError) {
                    if (empty) {
                        Throwable e = this.error;
                        if (e != null) {
                            this.doError(a, e);
                        } else {
                            this.doComplete(a);
                        }
                        return true;
                    }
                } else {
                    Throwable e = this.error;
                    if (e != null) {
                        this.queue.clear();
                        this.doError(a, e);
                        return true;
                    }
                    if (empty) {
                        this.doComplete(a);
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public T poll() {
            T v = this.queue.poll();
            if (v != null && this.sourceMode != 1) {
                long p = this.consumed + 1L;
                if (p == (long)this.limit) {
                    this.consumed = 0L;
                    this.s.request(p);
                } else {
                    this.consumed = p;
                }
            }
            return v;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.queue.size();
        }
    }

    static final class PublishOnSubscriber<T>
    implements Fuseable.QueueSubscription<T>,
    Runnable,
    InnerOperator<T, T> {
        final Subscriber<? super T> actual;
        final Scheduler scheduler;
        final Scheduler.Worker worker;
        final boolean delayError;
        final int prefetch;
        final int limit;
        final Supplier<? extends Queue<T>> queueSupplier;
        Subscription s;
        Queue<T> queue;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<PublishOnSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(PublishOnSubscriber.class, "wip");
        volatile long requested;
        static final AtomicLongFieldUpdater<PublishOnSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(PublishOnSubscriber.class, "requested");
        int sourceMode;
        long produced;
        boolean outputFused;

        PublishOnSubscriber(Subscriber<? super T> actual, Scheduler scheduler, Scheduler.Worker worker, boolean delayError, int prefetch, Supplier<? extends Queue<T>> queueSupplier) {
            this.actual = actual;
            this.worker = worker;
            this.scheduler = scheduler;
            this.delayError = delayError;
            this.prefetch = prefetch;
            this.queueSupplier = queueSupplier;
            this.limit = prefetch != Integer.MAX_VALUE ? prefetch - (prefetch >> 2) : Integer.MAX_VALUE;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                if (s instanceof Fuseable.QueueSubscription) {
                    Fuseable.QueueSubscription f = (Fuseable.QueueSubscription)s;
                    int m = f.requestFusion(7);
                    if (m == 1) {
                        this.sourceMode = 1;
                        this.queue = f;
                        this.done = true;
                        this.actual.onSubscribe((Subscription)this);
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = 2;
                        this.queue = f;
                        this.actual.onSubscribe((Subscription)this);
                        this.initialRequest();
                        return;
                    }
                }
                this.queue = this.queueSupplier.get();
                this.actual.onSubscribe((Subscription)this);
                this.initialRequest();
            }
        }

        void initialRequest() {
            if (this.prefetch == Integer.MAX_VALUE) {
                this.s.request(Long.MAX_VALUE);
            } else {
                this.s.request((long)this.prefetch);
            }
        }

        public void onNext(T t) {
            if (t == null) {
                if (this.trySchedule() == Scheduler.REJECTED) {
                    throw Operators.onRejectedExecution(this, null, t);
                }
                return;
            }
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            if (!this.queue.offer(t)) {
                this.error = Operators.onOperatorError(this.s, Exceptions.failWithOverflow("Queue is full?!"), t);
                this.done = true;
            }
            if (this.trySchedule() == Scheduler.REJECTED) {
                throw Operators.onRejectedExecution(this, null, t);
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.error = t;
            this.done = true;
            if (this.trySchedule() == Scheduler.REJECTED) {
                throw Operators.onRejectedExecution(null, t, null);
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.trySchedule() == Scheduler.REJECTED && !this.worker.isDisposed()) {
                throw Operators.onRejectedExecution();
            }
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                if (this.trySchedule() == Scheduler.REJECTED && (!this.worker.isDisposed() || this.scheduler.isDisposed())) {
                    throw Operators.onRejectedExecution(this, null, null);
                }
            }
        }

        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.s.cancel();
            this.worker.dispose();
            if (WIP.getAndIncrement(this) == 0) {
                this.queue.clear();
            }
        }

        Cancellation trySchedule() {
            if (WIP.getAndIncrement(this) != 0) {
                return null;
            }
            return this.worker.schedule(this);
        }

        void runSync() {
            int missed = 1;
            Subscriber<? super T> a = this.actual;
            Queue<T> q = this.queue;
            long e = this.produced;
            while (true) {
                long r = this.requested;
                while (e != r) {
                    T v;
                    try {
                        v = q.poll();
                    }
                    catch (Throwable ex) {
                        this.doError(a, Operators.onOperatorError(this.s, ex));
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (v == null) {
                        this.doComplete(a);
                        return;
                    }
                    a.onNext(v);
                    ++e;
                }
                if (this.cancelled) {
                    return;
                }
                if (q.isEmpty()) {
                    this.doComplete(a);
                    return;
                }
                int w = this.wip;
                if (missed == w) {
                    this.produced = e;
                    if ((missed = WIP.addAndGet(this, -missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        void runAsync() {
            int missed = 1;
            Subscriber<? super T> a = this.actual;
            Queue<T> q = this.queue;
            long e = this.produced;
            while (true) {
                long r = this.requested;
                while (e != r) {
                    boolean empty;
                    T v;
                    boolean d = this.done;
                    try {
                        v = q.poll();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.s.cancel();
                        q.clear();
                        this.doError(a, Operators.onOperatorError(ex));
                        return;
                    }
                    boolean bl = empty = v == null;
                    if (this.checkTerminated(d, empty, a)) {
                        return;
                    }
                    if (empty) break;
                    a.onNext(v);
                    if (++e != (long)this.limit) continue;
                    if (r != Long.MAX_VALUE) {
                        r = REQUESTED.addAndGet(this, -e);
                    }
                    this.s.request(e);
                    e = 0L;
                }
                if (e == r && this.checkTerminated(this.done, q.isEmpty(), a)) {
                    return;
                }
                int w = this.wip;
                if (missed == w) {
                    this.produced = e;
                    if ((missed = WIP.addAndGet(this, -missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        void runBackfused() {
            int missed = 1;
            do {
                if (this.cancelled) {
                    return;
                }
                boolean d = this.done;
                this.actual.onNext(null);
                if (!d) continue;
                Throwable e = this.error;
                if (e != null) {
                    this.doError(this.actual, e);
                } else {
                    this.doComplete(this.actual);
                }
                return;
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        void doComplete(Subscriber<?> a) {
            try {
                a.onComplete();
            }
            finally {
                this.worker.dispose();
            }
        }

        void doError(Subscriber<?> a, Throwable e) {
            try {
                a.onError(e);
            }
            finally {
                this.worker.dispose();
            }
        }

        @Override
        public void run() {
            if (this.outputFused) {
                this.runBackfused();
            } else if (this.sourceMode == 1) {
                this.runSync();
            } else {
                this.runAsync();
            }
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a) {
            if (this.cancelled) {
                this.queue.clear();
                return true;
            }
            if (d) {
                if (this.delayError) {
                    if (empty) {
                        Throwable e = this.error;
                        if (e != null) {
                            this.doError(a, e);
                        } else {
                            this.doComplete(a);
                        }
                        return true;
                    }
                } else {
                    Throwable e = this.error;
                    if (e != null) {
                        this.queue.clear();
                        this.doError(a, e);
                        return true;
                    }
                    if (empty) {
                        this.doComplete(a);
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
                case PARENT: {
                    return this.s;
                }
                case CANCELLED: {
                    return this.cancelled;
                }
                case TERMINATED: {
                    return this.done;
                }
                case BUFFERED: {
                    return this.queue != null ? this.queue.size() : 0;
                }
                case ERROR: {
                    return this.error;
                }
                case DELAY_ERROR: {
                    return this.delayError;
                }
                case PREFETCH: {
                    return this.prefetch;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public T poll() {
            T v = this.queue.poll();
            if (v != null && this.sourceMode != 1) {
                long p = this.produced + 1L;
                if (p == (long)this.limit) {
                    this.produced = 0L;
                    this.s.request(p);
                } else {
                    this.produced = p;
                }
            }
            return v;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.queue.size();
        }
    }
}

