/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Operators;

final class LambdaMonoSubscriber<T>
implements Subscriber<T>,
Scannable,
Disposable {
    final Consumer<? super T> consumer;
    final Consumer<? super Throwable> errorConsumer;
    final Runnable completeConsumer;
    final Consumer<? super Subscription> subscriptionConsumer;
    volatile Subscription subscription;
    static final AtomicReferenceFieldUpdater<LambdaMonoSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(LambdaMonoSubscriber.class, Subscription.class, "subscription");

    LambdaMonoSubscriber(Consumer<? super T> consumer, Consumer<? super Throwable> errorConsumer, Runnable completeConsumer, Consumer<? super Subscription> subscriptionConsumer) {
        this.consumer = consumer;
        this.errorConsumer = errorConsumer;
        this.completeConsumer = completeConsumer;
        this.subscriptionConsumer = subscriptionConsumer;
    }

    public final void onSubscribe(Subscription s) {
        if (Operators.validate(this.subscription, s)) {
            this.subscription = s;
            try {
                if (this.subscriptionConsumer != null) {
                    this.subscriptionConsumer.accept((Subscription)s);
                } else {
                    s.request(Long.MAX_VALUE);
                }
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal(t);
                s.cancel();
                this.onError(t);
            }
        }
    }

    public final void onComplete() {
        Subscription s = S.getAndSet(this, Operators.cancelledSubscription());
        if (s == Operators.cancelledSubscription()) {
            return;
        }
        if (this.completeConsumer != null) {
            try {
                this.completeConsumer.run();
            }
            catch (Throwable t) {
                Operators.onErrorDropped(t);
            }
        }
    }

    public final void onError(Throwable t) {
        if (t == null) {
            throw Exceptions.argumentIsNullException();
        }
        Subscription s = S.getAndSet(this, Operators.cancelledSubscription());
        if (s == Operators.cancelledSubscription()) {
            Operators.onErrorDropped(t);
            return;
        }
        this.doError(t);
    }

    void doError(Throwable t) {
        if (this.errorConsumer == null) {
            throw Exceptions.errorCallbackNotImplemented(t);
        }
        this.errorConsumer.accept(t);
    }

    public final void onNext(T x) {
        if (x == null) {
            throw Exceptions.argumentIsNullException();
        }
        Subscription s = S.getAndSet(this, Operators.cancelledSubscription());
        if (s == null || s == Operators.cancelledSubscription()) {
            Operators.onNextDropped(x);
            return;
        }
        if (this.consumer != null) {
            try {
                this.consumer.accept(x);
            }
            catch (Throwable t) {
                Operators.onErrorDropped(t);
                return;
            }
        }
        if (this.completeConsumer != null) {
            try {
                this.completeConsumer.run();
            }
            catch (Throwable t) {
                Operators.onErrorDropped(t);
            }
        }
    }

    @Override
    public Object scan(Scannable.Attr key) {
        switch (key) {
            case PARENT: {
                return this.subscription;
            }
            case PREFETCH: {
                return Integer.MAX_VALUE;
            }
            case TERMINATED: 
            case CANCELLED: {
                return this.isDisposed();
            }
        }
        return null;
    }

    @Override
    public boolean isDisposed() {
        return this.subscription == Operators.cancelledSubscription();
    }

    @Override
    public void dispose() {
        Subscription s = S.getAndSet(this, Operators.cancelledSubscription());
        if (s != null && s != Operators.cancelledSubscription()) {
            s.cancel();
        }
    }
}

