/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Subscriber;
import reactor.core.Scannable;
import reactor.core.publisher.FluxPeek;
import reactor.core.publisher.ParallelFlux;
import reactor.core.publisher.SignalPeek;

final class ParallelLog<T>
extends ParallelFlux<T>
implements Scannable {
    final ParallelFlux<T> source;
    final SignalPeek<T> log;

    ParallelLog(ParallelFlux<T> source, SignalPeek<T> log) {
        this.source = source;
        this.log = log;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            parents[i] = new FluxPeek.PeekSubscriber<T>(subscribers[i], this.log);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public long getPrefetch() {
        return this.source.getPrefetch();
    }

    @Override
    public Object scan(Scannable.Attr key) {
        switch (key) {
            case PARENT: {
                return this.source;
            }
            case PREFETCH: {
                return this.getPrefetch();
            }
        }
        return null;
    }
}

