/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import reactor.core.Disposable;
import reactor.core.scheduler.ExecutorServiceScheduler;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.concurrent.OpenHashSet;

final class ElasticScheduler
implements Scheduler,
Supplier<ScheduledExecutorService> {
    static final AtomicLong COUNTER = new AtomicLong();
    static final ThreadFactory EVICTOR_FACTORY = r -> {
        Thread t = new Thread(r, "elastic-evictor-" + COUNTER.incrementAndGet());
        t.setDaemon(true);
        return t;
    };
    final ThreadFactory factory;
    final int ttlSeconds;
    static final int DEFAULT_TTL_SECONDS = 60;
    final Queue<ScheduledExecutorServiceExpiry> cache;
    final Queue<ScheduledExecutorService> all;
    final ScheduledExecutorService evictor;
    static final ScheduledExecutorService SHUTDOWN = Executors.newSingleThreadScheduledExecutor();
    volatile boolean shutdown;

    ElasticScheduler(ThreadFactory factory, int ttlSeconds) {
        if (ttlSeconds < 0) {
            throw new IllegalArgumentException("ttlSeconds must be positive, was: " + ttlSeconds);
        }
        this.ttlSeconds = ttlSeconds;
        this.factory = factory;
        this.cache = new ConcurrentLinkedQueue<ScheduledExecutorServiceExpiry>();
        this.all = new ConcurrentLinkedQueue<ScheduledExecutorService>();
        this.evictor = Executors.newScheduledThreadPool(1, EVICTOR_FACTORY);
        this.evictor.scheduleAtFixedRate(this::eviction, ttlSeconds, ttlSeconds, TimeUnit.SECONDS);
    }

    @Override
    public ScheduledExecutorService get() {
        return Executors.newSingleThreadScheduledExecutor(this.factory);
    }

    @Override
    public void start() {
        throw new UnsupportedOperationException("Restarting not supported yet");
    }

    @Override
    public boolean isDisposed() {
        return this.shutdown;
    }

    @Override
    public void shutdown() {
        this.dispose();
    }

    @Override
    public void dispose() {
        ScheduledExecutorService exec;
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.evictor.shutdownNow();
        this.cache.clear();
        while ((exec = this.all.poll()) != null) {
            exec.shutdownNow();
        }
    }

    ScheduledExecutorService pick() {
        if (this.shutdown) {
            return SHUTDOWN;
        }
        ScheduledExecutorServiceExpiry e = this.cache.poll();
        if (e != null) {
            return e.executor;
        }
        ScheduledExecutorService result = Schedulers.decorateScheduledExecutorService("elastic", this);
        this.all.offer(result);
        if (this.shutdown) {
            this.all.remove(result);
            return SHUTDOWN;
        }
        return result;
    }

    @Override
    public Disposable schedule(Runnable task) {
        Future<?> f;
        ScheduledExecutorService exec = this.pick();
        Runnable wrapper = () -> {
            try {
                task.run();
            }
            catch (Throwable ex) {
                Schedulers.handleError(ex);
            }
            finally {
                this.release(exec);
            }
        };
        try {
            f = exec.submit(wrapper);
        }
        catch (RejectedExecutionException ex) {
            return REJECTED;
        }
        return new ExecutorServiceScheduler.DisposableFuture(f, true);
    }

    @Override
    public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        ScheduledFuture<?> f;
        ScheduledExecutorService exec = this.pick();
        Runnable wrapper = () -> {
            try {
                task.run();
            }
            catch (Throwable ex) {
                Schedulers.handleError(ex);
            }
            finally {
                this.release(exec);
            }
        };
        try {
            f = exec.schedule(wrapper, delay, unit);
        }
        catch (RejectedExecutionException ex) {
            return REJECTED;
        }
        return new ExecutorServiceScheduler.DisposableFuture(f, true);
    }

    @Override
    public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        ScheduledFuture<?> f;
        ScheduledExecutorService exec = this.pick();
        Runnable wrapper = () -> {
            try {
                task.run();
            }
            catch (Throwable ex) {
                Schedulers.handleError(ex);
            }
            finally {
                this.release(exec);
            }
        };
        try {
            f = exec.scheduleAtFixedRate(wrapper, initialDelay, period, unit);
        }
        catch (RejectedExecutionException ex) {
            return REJECTED;
        }
        return new ExecutorServiceScheduler.DisposableFuture(f, true);
    }

    @Override
    public Scheduler.Worker createWorker() {
        ScheduledExecutorService exec = this.pick();
        return new CachedWorker(exec, this);
    }

    void release(ScheduledExecutorService exec) {
        if (exec != SHUTDOWN && !this.shutdown) {
            ScheduledExecutorServiceExpiry e = new ScheduledExecutorServiceExpiry(exec, System.currentTimeMillis() + (long)this.ttlSeconds * 1000L);
            this.cache.offer(e);
            if (this.shutdown && this.cache.remove(e)) {
                exec.shutdownNow();
            }
        }
    }

    void eviction() {
        long now = System.currentTimeMillis();
        ArrayList<ScheduledExecutorServiceExpiry> list = new ArrayList<ScheduledExecutorServiceExpiry>(this.cache);
        for (ScheduledExecutorServiceExpiry e : list) {
            if (e.expireMillis >= now || !this.cache.remove(e)) continue;
            e.executor.shutdownNow();
        }
    }

    static {
        SHUTDOWN.shutdownNow();
    }

    static final class CachedWorker
    implements Scheduler.Worker {
        final ScheduledExecutorService executor;
        final ElasticScheduler parent;
        volatile boolean shutdown;
        OpenHashSet<CachedTask> tasks;

        CachedWorker(ScheduledExecutorService executor, ElasticScheduler parent) {
            this.executor = executor;
            this.parent = parent;
            this.tasks = new OpenHashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Disposable schedule(Runnable task) {
            Future<?> f;
            if (this.shutdown) {
                return Scheduler.REJECTED;
            }
            CachedTask ct = new CachedTask(task, this);
            CachedWorker cachedWorker = this;
            synchronized (cachedWorker) {
                if (this.shutdown) {
                    return Scheduler.REJECTED;
                }
                this.tasks.add(ct);
            }
            try {
                f = this.executor.submit(ct);
            }
            catch (RejectedExecutionException ex) {
                return Scheduler.REJECTED;
            }
            ct.setFuture(f);
            return ct;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
            ScheduledFuture<?> f;
            if (this.shutdown) {
                return Scheduler.REJECTED;
            }
            CachedTask ct = new CachedTask(task, this);
            CachedWorker cachedWorker = this;
            synchronized (cachedWorker) {
                if (this.shutdown) {
                    return Scheduler.REJECTED;
                }
                this.tasks.add(ct);
            }
            try {
                f = this.executor.schedule(ct, delay, unit);
            }
            catch (RejectedExecutionException ex) {
                return Scheduler.REJECTED;
            }
            ct.setFuture(f);
            return ct;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            ScheduledFuture<?> f;
            if (this.shutdown) {
                return Scheduler.REJECTED;
            }
            CachedTask ct = new CachedTask(task, this);
            CachedWorker cachedWorker = this;
            synchronized (cachedWorker) {
                if (this.shutdown) {
                    return Scheduler.REJECTED;
                }
                this.tasks.add(ct);
            }
            try {
                f = this.executor.scheduleAtFixedRate(ct, initialDelay, period, unit);
            }
            catch (RejectedExecutionException ex) {
                return Scheduler.REJECTED;
            }
            ct.setFuture(f);
            return ct;
        }

        @Override
        public void shutdown() {
            this.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            OpenHashSet<CachedTask> set;
            if (this.shutdown) {
                return;
            }
            CachedWorker cachedWorker = this;
            synchronized (cachedWorker) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                set = this.tasks;
                this.tasks = null;
            }
            if (!set.isEmpty()) {
                Object[] keys;
                for (Object o : keys = set.keys()) {
                    if (o == null) continue;
                    ((CachedTask)o).cancelFuture();
                }
            }
            this.parent.release(this.executor);
        }

        @Override
        public boolean isDisposed() {
            return this.shutdown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(CachedTask task) {
            if (this.shutdown) {
                return;
            }
            CachedWorker cachedWorker = this;
            synchronized (cachedWorker) {
                if (this.shutdown) {
                    return;
                }
                this.tasks.remove(task);
            }
        }

        static final class CachedTask
        extends AtomicReference<Future<?>>
        implements Runnable,
        Disposable {
            private static final long serialVersionUID = 6799295393954430738L;
            final Runnable run;
            final CachedWorker parent;
            volatile boolean cancelled;

            CachedTask(Runnable run, CachedWorker parent) {
                this.run = run;
                this.parent = parent;
            }

            @Override
            public void run() {
                try {
                    if (!this.parent.shutdown && !this.cancelled) {
                        this.run.run();
                    }
                }
                catch (Throwable ex) {
                    Schedulers.handleError(ex);
                }
                finally {
                    this.lazySet(ExecutorServiceScheduler.FINISHED);
                    this.parent.remove(this);
                }
            }

            @Override
            public void dispose() {
                this.cancelled = true;
                this.cancelFuture();
            }

            @Override
            public boolean isDisposed() {
                Future f = (Future)this.get();
                return f == ExecutorServiceScheduler.CANCELLED || f == ExecutorServiceScheduler.FINISHED;
            }

            void setFuture(Future<?> f) {
                if (!this.compareAndSet(null, f) && this.get() != ExecutorServiceScheduler.FINISHED) {
                    f.cancel(true);
                }
            }

            void cancelFuture() {
                Future<?> f = (Future<?>)this.get();
                if (f != ExecutorServiceScheduler.CANCELLED && f != ExecutorServiceScheduler.FINISHED && (f = this.getAndSet(ExecutorServiceScheduler.CANCELLED)) != null && f != ExecutorServiceScheduler.CANCELLED && f != ExecutorServiceScheduler.FINISHED) {
                    f.cancel(true);
                }
            }
        }
    }

    static final class ScheduledExecutorServiceExpiry {
        final ScheduledExecutorService executor;
        final long expireMillis;

        ScheduledExecutorServiceExpiry(ScheduledExecutorService executor, long expireMillis) {
            this.executor = executor;
            this.expireMillis = expireMillis;
        }
    }
}

