/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.security;

import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.security.ServerSecurityException;
import org.mule.runtime.core.api.security.SecurityContext;

public class UnauthorisedException
extends ServerSecurityException {
    private static final long serialVersionUID = -6664384216189042673L;

    public UnauthorisedException(I18nMessage message) {
        super(message);
    }

    public UnauthorisedException(I18nMessage message, Throwable cause) {
        super(message, cause);
    }

    public UnauthorisedException(SecurityContext context, String filter, String connector) {
        super(UnauthorisedException.constructMessage(context, connector, filter));
    }

    private static I18nMessage constructMessage(SecurityContext context, String originatingConnectorName, String filter) {
        I18nMessage m = context == null ? I18nMessageFactory.createStaticMessage((String)"Registered authentication is set to %s but there was no security context on the session", (Object[])new Object[]{filter}) : I18nMessageFactory.createStaticMessage((String)"Authentication failed for principal %s", (Object[])new Object[]{context.getAuthentication().getPrincipal()});
        m.setNextMessage(I18nMessageFactory.createStaticMessage((String)"Authentication denied on connector %s", (Object[])new Object[]{originatingConnectorName}));
        return m;
    }
}

