/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.util.NameUtils;

public final class ExtensionMetadataTypeUtils {
    private ExtensionMetadataTypeUtils() {
    }

    public static Optional<Class<?>> getType(MetadataType metadataType) {
        return ExtensionMetadataTypeUtils.getType(metadataType, Thread.currentThread().getContextClassLoader());
    }

    public static Optional<Class<?>> getType(MetadataType metadataType, ClassLoader classloader) {
        if (!metadataType.getMetadataFormat().equals((Object)MetadataFormat.JAVA)) {
            return Optional.empty();
        }
        try {
            return Optional.of(JavaTypeUtils.getType((MetadataType)metadataType, (ClassLoader)classloader));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static String getAlias(ObjectFieldType fieldType) {
        return fieldType.getAnnotation(TypeAliasAnnotation.class).map(TypeAliasAnnotation::getValue).orElse(MetadataTypeUtils.getLocalPart((ObjectFieldType)fieldType));
    }

    public static String getAlias(MetadataType metadataType) {
        return ExtensionMetadataTypeUtils.getAlias(metadataType, "");
    }

    public static String getAlias(MetadataType metadataType, String defaultName) {
        return metadataType.getAnnotation(TypeAliasAnnotation.class).map(TypeAliasAnnotation::getValue).orElseGet(() -> metadataType.getMetadataFormat().equals((Object)MetadataFormat.JAVA) ? NameUtils.getAliasName(defaultName, ExtensionMetadataTypeUtils.getType(metadataType).map(t -> t.getAnnotation(Alias.class)).orElse(null)) : defaultName);
    }

    public static boolean isFinal(MetadataType metadataType) {
        try {
            return metadataType.getAnnotation(ClassInformationAnnotation.class).map(ClassInformationAnnotation::isFinal).orElseGet(() -> metadataType.getMetadataFormat().equals((Object)MetadataFormat.JAVA) && ExtensionMetadataTypeUtils.getType(metadataType).map(t -> Modifier.isFinal(t.getModifiers())).orElse(false) != false);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isMap(MetadataType metadataType) {
        if (metadataType.getAnnotation(TypeIdAnnotation.class).isPresent() && Map.class.getName().equals(((TypeIdAnnotation)metadataType.getAnnotation(TypeIdAnnotation.class).get()).getValue())) {
            return true;
        }
        return metadataType.getAnnotation(ClassInformationAnnotation.class).map(classInformationAnnotation -> classInformationAnnotation.getImplementedInterfaces().contains(Map.class.getName())).orElse(false);
    }

    public static String getId(MetadataType metadataType) {
        try {
            return MetadataTypeUtils.getTypeId((MetadataType)metadataType).orElseGet(() -> ExtensionMetadataTypeUtils.getType(metadataType).map(Class::getName).orElse(""));
        }
        catch (Exception e) {
            return "";
        }
    }

    public static boolean isInputStream(MetadataType type) {
        try {
            return ExtensionMetadataTypeUtils.getType(type).map(InputStream.class::isAssignableFrom).orElse(false);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isFlattenedParameterGroup(MetadataType type) {
        return type.getAnnotation(FlattenedTypeAnnotation.class).isPresent();
    }
}

