/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.processor;

import java.util.Arrays;
import java.util.List;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.config.spring.dsl.processor.TransformerObjectFactory;
import org.mule.runtime.core.expression.ExpressionConfig;
import org.mule.runtime.core.expression.transformers.ExpressionArgument;
import org.mule.runtime.core.expression.transformers.ExpressionTransformer;
import org.mule.runtime.core.transformer.AbstractTransformer;

public class ExpressionTransformerObjectFactory
extends TransformerObjectFactory
implements Initialisable {
    private boolean returnSourceIfNull = false;
    private String expression;
    protected List<ExpressionArgument> arguments;

    @Override
    protected AbstractTransformer createInstance() {
        ExpressionTransformer expressionTransformer = new ExpressionTransformer();
        expressionTransformer.setReturnSourceIfNull(this.returnSourceIfNull);
        expressionTransformer.setArguments(this.arguments);
        return expressionTransformer;
    }

    public void setReturnSourceIfNull(boolean returnSourceIfNull) {
        this.returnSourceIfNull = returnSourceIfNull;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void initialise() throws InitialisationException {
        if (this.expression != null && this.arguments != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Expression transformer do not support expression attribute or return-data child element at the same time."), (Initialisable)this);
        }
        if (this.expression != null) {
            this.arguments = Arrays.asList(new ExpressionArgument("single", new ExpressionConfig(this.expression), false));
        }
    }
}

