/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SignalType;

final class FluxDoFinally<T>
extends FluxSource<T, T> {
    final Consumer<SignalType> onFinally;

    static <T> Subscriber<T> createSubscriber(Subscriber<? super T> s, Consumer<SignalType> onFinally, boolean fuseable) {
        if (fuseable) {
            if (s instanceof Fuseable.ConditionalSubscriber) {
                return new DoFinallyFuseableConditionalSubscriber((Fuseable.ConditionalSubscriber)s, onFinally);
            }
            return new DoFinallyFuseableSubscriber<T>(s, onFinally);
        }
        if (s instanceof Fuseable.ConditionalSubscriber) {
            return new DoFinallyConditionalSubscriber((Fuseable.ConditionalSubscriber)s, onFinally);
        }
        return new DoFinallySubscriber<T>(s, onFinally);
    }

    FluxDoFinally(Flux<? extends T> source, Consumer<SignalType> onFinally) {
        super(source);
        this.onFinally = onFinally;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(FluxDoFinally.createSubscriber(s, this.onFinally, false));
    }

    static final class DoFinallyFuseableConditionalSubscriber<T>
    extends DoFinallyFuseableSubscriber<T>
    implements Fuseable.ConditionalSubscriber<T> {
        DoFinallyFuseableConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, Consumer<SignalType> onFinally) {
            super(actual, onFinally);
        }

        @Override
        public boolean tryOnNext(T t) {
            return ((Fuseable.ConditionalSubscriber)this.actual).tryOnNext(t);
        }
    }

    static final class DoFinallyConditionalSubscriber<T>
    extends DoFinallySubscriber<T>
    implements Fuseable.ConditionalSubscriber<T> {
        DoFinallyConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, Consumer<SignalType> onFinally) {
            super(actual, onFinally);
        }

        @Override
        public boolean tryOnNext(T t) {
            return ((Fuseable.ConditionalSubscriber)this.actual).tryOnNext(t);
        }
    }

    static class DoFinallyFuseableSubscriber<T>
    extends DoFinallySubscriber<T>
    implements Fuseable,
    Fuseable.QueueSubscription<T> {
        DoFinallyFuseableSubscriber(Subscriber<? super T> actual, Consumer<SignalType> onFinally) {
            super(actual, onFinally);
        }

        @Override
        public int requestFusion(int mode) {
            Fuseable.QueueSubscription qs = this.qs;
            if (qs != null && (mode & 4) == 0) {
                int m = qs.requestFusion(mode);
                if (m != 0) {
                    this.syncFused = m == 1;
                }
                return m;
            }
            return 0;
        }

        @Override
        public void clear() {
            if (this.qs != null) {
                this.qs.clear();
            }
        }

        @Override
        public boolean isEmpty() {
            return this.qs == null || this.qs.isEmpty();
        }

        @Override
        public T poll() {
            if (this.qs == null) {
                return null;
            }
            Object v = this.qs.poll();
            if (v == null && this.syncFused) {
                this.runFinally(SignalType.ON_COMPLETE);
            }
            return (T)v;
        }

        @Override
        public int size() {
            return this.qs == null ? 0 : this.qs.size();
        }
    }

    static class DoFinallySubscriber<T>
    implements InnerOperator<T, T> {
        final Subscriber<? super T> actual;
        final Consumer<SignalType> onFinally;
        volatile int once;
        static final AtomicIntegerFieldUpdater<DoFinallySubscriber> ONCE = AtomicIntegerFieldUpdater.newUpdater(DoFinallySubscriber.class, "once");
        Fuseable.QueueSubscription<T> qs;
        Subscription s;
        boolean syncFused;

        DoFinallySubscriber(Subscriber<? super T> actual, Consumer<SignalType> onFinally) {
            this.actual = actual;
            this.onFinally = onFinally;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case TERMINATED: 
                case CANCELLED: {
                    return this.once == 1;
                }
            }
            return InnerOperator.super.scan(key);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                if (s instanceof Fuseable.QueueSubscription) {
                    this.qs = (Fuseable.QueueSubscription)s;
                }
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
            this.runFinally(SignalType.ON_ERROR);
        }

        public void onComplete() {
            this.actual.onComplete();
            this.runFinally(SignalType.ON_COMPLETE);
        }

        public void cancel() {
            this.s.cancel();
            this.runFinally(SignalType.CANCEL);
        }

        public void request(long n) {
            this.s.request(n);
        }

        void runFinally(SignalType signalType) {
            if (ONCE.compareAndSet(this, 0, 1)) {
                try {
                    this.onFinally.accept(signalType);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    Operators.onErrorDropped(ex);
                }
            }
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }
    }
}

