/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BooleanSupplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.DrainUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Signal;

final class FluxMaterialize<T>
extends FluxSource<T, Signal<T>> {
    FluxMaterialize(Flux<T> source) {
        super(source);
    }

    @Override
    public void subscribe(Subscriber<? super Signal<T>> subscriber) {
        this.source.subscribe(new MaterializeSubscriber(subscriber));
    }

    static final class MaterializeSubscriber<T>
    extends AbstractQueue<Signal<T>>
    implements InnerOperator<T, Signal<T>>,
    BooleanSupplier {
        final Subscriber<? super Signal<T>> actual;
        Signal<T> terminalSignal;
        volatile boolean cancelled;
        volatile long requested;
        static final AtomicLongFieldUpdater<MaterializeSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(MaterializeSubscriber.class, "requested");
        long produced;
        Subscription s;
        static final Signal empty = Signal.next(null);

        MaterializeSubscriber(Subscriber<? super Signal<T>> subscriber) {
            this.actual = subscriber;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case TERMINATED: {
                    return this.terminalSignal != null;
                }
                case ERROR: {
                    return this.terminalSignal != null ? this.terminalSignal.getThrowable() : null;
                }
                case CANCELLED: {
                    return this.getAsBoolean();
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
                case BUFFERED: {
                    return this.size();
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Subscriber<? super Signal<T>> actual() {
            return this.actual;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T ev) {
            if (this.terminalSignal != null) {
                Operators.onNextDropped(ev);
                return;
            }
            ++this.produced;
            this.actual.onNext(Signal.next(ev));
        }

        public void onError(Throwable ev) {
            if (this.terminalSignal != null) {
                Operators.onErrorDropped(ev);
                return;
            }
            this.terminalSignal = Signal.error(ev);
            long p = this.produced;
            if (p != 0L) {
                Operators.addAndGet(REQUESTED, this, -p);
            }
            DrainUtils.postComplete(this.actual, this, REQUESTED, this, this);
        }

        public void onComplete() {
            if (this.terminalSignal != null) {
                return;
            }
            this.terminalSignal = Signal.complete();
            long p = this.produced;
            if (p != 0L) {
                Operators.addAndGet(REQUESTED, this, -p);
            }
            DrainUtils.postComplete(this.actual, this, REQUESTED, this, this);
        }

        public void request(long n) {
            if (Operators.validate(n) && !DrainUtils.postCompleteRequest(n, this.actual, this, REQUESTED, this, this)) {
                this.s.request(n);
            }
        }

        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.s.cancel();
        }

        @Override
        public boolean getAsBoolean() {
            return this.cancelled;
        }

        @Override
        public boolean offer(Signal<T> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Signal<T> poll() {
            Signal<T> v = this.terminalSignal;
            if (v != null && v != empty) {
                this.terminalSignal = empty;
                return v;
            }
            return null;
        }

        @Override
        public Signal<T> peek() {
            return empty == this.terminalSignal ? null : this.terminalSignal;
        }

        @Override
        public Iterator<Signal<T>> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.terminalSignal == null || this.terminalSignal == empty ? 0 : 1;
        }
    }
}

