/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import reactor.core.Cancellation;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

final class FluxSubscribeOnCallable<T>
extends Flux<T>
implements Fuseable {
    final Callable<? extends T> callable;
    final Scheduler scheduler;

    FluxSubscribeOnCallable(Callable<? extends T> callable, Scheduler scheduler) {
        this.callable = Objects.requireNonNull(callable, "callable");
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
    }

    public void subscribe(Subscriber<? super T> s) {
        CallableSubscribeOnSubscription<T> parent = new CallableSubscribeOnSubscription<T>(s, this.callable, this.scheduler);
        s.onSubscribe(parent);
        Cancellation f = this.scheduler.schedule(parent);
        if (f == Scheduler.REJECTED) {
            if (parent.state != 4) {
                s.onError((Throwable)Operators.onRejectedExecution());
            }
        } else {
            parent.setMainFuture(f);
        }
    }

    static final class CallableSubscribeOnSubscription<T>
    implements Fuseable.QueueSubscription<T>,
    InnerProducer<T>,
    Runnable {
        final Subscriber<? super T> actual;
        final Callable<? extends T> callable;
        final Scheduler scheduler;
        volatile int state;
        static final AtomicIntegerFieldUpdater<CallableSubscribeOnSubscription> STATE = AtomicIntegerFieldUpdater.newUpdater(CallableSubscribeOnSubscription.class, "state");
        T value;
        static final int NO_REQUEST_HAS_VALUE = 1;
        static final int HAS_REQUEST_NO_VALUE = 2;
        static final int HAS_REQUEST_HAS_VALUE = 3;
        static final int HAS_CANCELLED = 4;
        int fusionState;
        static final int NO_VALUE = 1;
        static final int HAS_VALUE = 2;
        static final int COMPLETE = 3;
        volatile Cancellation mainFuture;
        static final AtomicReferenceFieldUpdater<CallableSubscribeOnSubscription, Cancellation> MAIN_FUTURE = AtomicReferenceFieldUpdater.newUpdater(CallableSubscribeOnSubscription.class, Cancellation.class, "mainFuture");
        volatile Cancellation requestFuture;
        static final AtomicReferenceFieldUpdater<CallableSubscribeOnSubscription, Cancellation> REQUEST_FUTURE = AtomicReferenceFieldUpdater.newUpdater(CallableSubscribeOnSubscription.class, Cancellation.class, "requestFuture");

        CallableSubscribeOnSubscription(Subscriber<? super T> actual, Callable<? extends T> callable, Scheduler scheduler) {
            this.actual = actual;
            this.callable = callable;
            this.scheduler = scheduler;
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case CANCELLED: {
                    return this.state == 4;
                }
                case BUFFERED: {
                    return this.value != null ? 1 : 0;
                }
            }
            return InnerProducer.super.scan(key);
        }

        public void cancel() {
            this.state = 4;
            this.fusionState = 3;
            Cancellation a = this.mainFuture;
            if (a != Flux.CANCELLED && (a = MAIN_FUTURE.getAndSet(this, Flux.CANCELLED)) != null && a != Flux.CANCELLED) {
                a.dispose();
            }
            if ((a = this.requestFuture) != Flux.CANCELLED && (a = REQUEST_FUTURE.getAndSet(this, Flux.CANCELLED)) != null && a != Flux.CANCELLED) {
                a.dispose();
            }
        }

        @Override
        public void clear() {
            this.value = null;
            this.fusionState = 3;
        }

        @Override
        public boolean isEmpty() {
            return this.fusionState == 3;
        }

        @Override
        public T poll() {
            if (this.fusionState == 2) {
                this.fusionState = 3;
                return this.value;
            }
            return null;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0 && (requestedMode & 4) == 0) {
                this.fusionState = 1;
                return 2;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.isEmpty() ? 0 : 1;
        }

        void setMainFuture(Cancellation c) {
            Cancellation a;
            do {
                if ((a = this.mainFuture) != Flux.CANCELLED) continue;
                c.dispose();
                return;
            } while (!MAIN_FUTURE.compareAndSet(this, a, c));
        }

        void setRequestFuture(Cancellation c) {
            Cancellation a;
            do {
                if ((a = this.requestFuture) != Flux.CANCELLED) continue;
                c.dispose();
                return;
            } while (!REQUEST_FUTURE.compareAndSet(this, a, c));
        }

        @Override
        public void run() {
            int s;
            T v;
            try {
                v = this.callable.call();
            }
            catch (Throwable ex) {
                this.actual.onError(Operators.onOperatorError(this, ex));
                return;
            }
            do {
                if ((s = this.state) == 4 || s == 3 || s == 1) {
                    return;
                }
                if (v == null) {
                    this.actual.onComplete();
                    return;
                }
                if (s == 2) {
                    if (this.fusionState == 1) {
                        this.value = v;
                        this.fusionState = 2;
                    }
                    this.actual.onNext(v);
                    if (this.state != 4) {
                        this.actual.onComplete();
                    }
                    return;
                }
                this.value = v;
            } while (!STATE.compareAndSet(this, s, 1));
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                int s;
                do {
                    if ((s = this.state) == 4 || s == 2 || s == 3) {
                        return;
                    }
                    if (s != 1) continue;
                    if (STATE.compareAndSet(this, s, 3)) {
                        Cancellation f = this.scheduler.schedule(this::emitValue);
                        if (f == Scheduler.REJECTED) {
                            this.actual.onError((Throwable)Operators.onRejectedExecution());
                        } else {
                            this.setRequestFuture(f);
                        }
                    }
                    return;
                } while (!STATE.compareAndSet(this, s, 2));
                return;
            }
        }

        void emitValue() {
            if (this.fusionState == 1) {
                this.fusionState = 2;
            }
            T v = this.value;
            this.clear();
            if (v != null) {
                this.actual.onNext(v);
            }
            if (this.state != 4) {
                this.actual.onComplete();
            }
        }
    }
}

