/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.concurrent.QueueSupplier;

final class MonoSequenceEqual<T>
extends Mono<Boolean> {
    final Publisher<? extends T> first;
    final Publisher<? extends T> second;
    final BiPredicate<? super T, ? super T> comparer;
    final int bufferSize;

    MonoSequenceEqual(Publisher<? extends T> first, Publisher<? extends T> second, BiPredicate<? super T, ? super T> comparer, int bufferSize) {
        this.first = Objects.requireNonNull(first, "first");
        this.second = Objects.requireNonNull(second, "second");
        this.comparer = Objects.requireNonNull(comparer, "comparer");
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer size must be strictly positive: " + bufferSize);
        }
        this.bufferSize = bufferSize;
    }

    public void subscribe(Subscriber<? super Boolean> s) {
        EqualCoordinator<T> ec = new EqualCoordinator<T>(s, this.bufferSize, this.first, this.second, this.comparer);
        s.onSubscribe(ec);
        ec.subscribe();
    }

    static final class EqualSubscriber<T>
    implements InnerConsumer<T> {
        final EqualCoordinator<T> parent;
        final Queue<T> queue;
        final int bufferSize;
        volatile boolean done;
        Throwable error;
        Subscription cachedSubscription;
        volatile Subscription subscription;
        static final AtomicReferenceFieldUpdater<EqualSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(EqualSubscriber.class, Subscription.class, "subscription");

        EqualSubscriber(EqualCoordinator<T> parent, int bufferSize) {
            this.parent = parent;
            this.bufferSize = bufferSize;
            this.queue = QueueSupplier.get(bufferSize).get();
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: {
                    return this.done;
                }
                case ACTUAL: {
                    return this.parent;
                }
                case ERROR: {
                    return this.error;
                }
                case CANCELLED: {
                    return this.subscription == Operators.cancelledSubscription();
                }
                case PARENT: {
                    return this.subscription;
                }
                case PREFETCH: {
                    return this.bufferSize;
                }
                case BUFFERED: {
                    return this.queue.size();
                }
            }
            return null;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                this.cachedSubscription = s;
                s.request((long)this.bufferSize);
            }
        }

        public void onNext(T t) {
            if (!this.queue.offer(t)) {
                this.onError(Operators.onOperatorError(this.cachedSubscription, Exceptions.failWithOverflow("Queue is full?!"), t));
                return;
            }
            this.parent.drain();
        }

        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.parent.drain();
        }

        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }
    }

    static final class EqualCoordinator<T>
    implements InnerProducer<Boolean> {
        final Subscriber<? super Boolean> actual;
        final BiPredicate<? super T, ? super T> comparer;
        final Publisher<? extends T> first;
        final Publisher<? extends T> second;
        final EqualSubscriber<T> firstSubscriber;
        final EqualSubscriber<T> secondSubscriber;
        volatile boolean cancelled;
        volatile int once;
        static final AtomicIntegerFieldUpdater<EqualCoordinator> ONCE = AtomicIntegerFieldUpdater.newUpdater(EqualCoordinator.class, "once");
        T v1;
        T v2;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<EqualCoordinator> WIP = AtomicIntegerFieldUpdater.newUpdater(EqualCoordinator.class, "wip");

        EqualCoordinator(Subscriber<? super Boolean> actual, int bufferSize, Publisher<? extends T> first, Publisher<? extends T> second, BiPredicate<? super T, ? super T> comparer) {
            this.actual = actual;
            this.first = first;
            this.second = second;
            this.comparer = comparer;
            this.firstSubscriber = new EqualSubscriber(this, bufferSize);
            this.secondSubscriber = new EqualSubscriber(this, bufferSize);
        }

        @Override
        public Subscriber<? super Boolean> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case CANCELLED: {
                    return this.cancelled;
                }
            }
            return InnerProducer.super.scan(key);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.firstSubscriber, this.secondSubscriber);
        }

        void subscribe() {
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.first.subscribe(this.firstSubscriber);
                this.second.subscribe(this.secondSubscriber);
            }
        }

        public void request(long n) {
            if (!Operators.validate(n)) {
                return;
            }
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.first.subscribe(this.firstSubscriber);
                this.second.subscribe(this.secondSubscriber);
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelInner(this.firstSubscriber);
                this.cancelInner(this.secondSubscriber);
                if (WIP.getAndIncrement(this) == 0) {
                    this.firstSubscriber.queue.clear();
                    this.secondSubscriber.queue.clear();
                }
            }
        }

        void cancel(EqualSubscriber<T> s1, Queue<T> q1, EqualSubscriber<T> s2, Queue<T> q2) {
            this.cancelled = true;
            this.cancelInner(s1);
            q1.clear();
            this.cancelInner(s2);
            q2.clear();
        }

        void cancelInner(EqualSubscriber<T> innerSubscriber) {
            Subscription s = innerSubscriber.subscription;
            if (s != Operators.cancelledSubscription() && (s = EqualSubscriber.S.getAndSet(innerSubscriber, Operators.cancelledSubscription())) != null && s != Operators.cancelledSubscription()) {
                s.cancel();
            }
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            int missed = 1;
            EqualSubscriber<T> s1 = this.firstSubscriber;
            Queue q1 = s1.queue;
            EqualSubscriber<T> s2 = this.secondSubscriber;
            Queue q2 = s2.queue;
            do {
                boolean e2;
                boolean e1;
                long r = 0L;
                do {
                    boolean c;
                    Throwable e;
                    Throwable e3;
                    if (this.cancelled) {
                        q1.clear();
                        q2.clear();
                        return;
                    }
                    boolean d1 = s1.done;
                    if (d1 && (e3 = s1.error) != null) {
                        this.cancel(s1, q1, s2, q2);
                        this.actual.onError(e3);
                        return;
                    }
                    boolean d2 = s2.done;
                    if (d2 && (e = s2.error) != null) {
                        this.cancel(s1, q1, s2, q2);
                        this.actual.onError(e);
                        return;
                    }
                    if (this.v1 == null) {
                        this.v1 = q1.poll();
                    }
                    boolean bl = e1 = this.v1 == null;
                    if (this.v2 == null) {
                        this.v2 = q2.poll();
                    }
                    boolean bl2 = e2 = this.v2 == null;
                    if (d1 && d2 && e1 && e2) {
                        this.actual.onNext((Object)true);
                        this.actual.onComplete();
                        return;
                    }
                    if (d1 && d2 && e1 != e2) {
                        this.cancel(s1, q1, s2, q2);
                        this.actual.onNext((Object)false);
                        this.actual.onComplete();
                        return;
                    }
                    if (e1 || e2) continue;
                    try {
                        c = this.comparer.test(this.v1, this.v2);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.cancel(s1, q1, s2, q2);
                        this.actual.onError(Operators.onOperatorError(ex));
                        return;
                    }
                    if (!c) {
                        this.cancel(s1, q1, s2, q2);
                        this.actual.onNext((Object)false);
                        this.actual.onComplete();
                        return;
                    }
                    ++r;
                    this.v1 = null;
                    this.v2 = null;
                } while (!e1 && !e2);
                if (r == 0L) continue;
                s1.cachedSubscription.request(r);
                s2.cachedSubscription.request(r);
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }
    }
}

